/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import pl.kasprowski.etcal.Callback;
import pl.kasprowski.etcal.ETCalException;
import pl.kasprowski.etcal.IETCal;
import pl.kasprowski.etcal.calibration.Calibrator;
import pl.kasprowski.etcal.calibration.RegressionData;
import pl.kasprowski.etcal.dataunits.DU2RDConverter;
import pl.kasprowski.etcal.dataunits.DataUnit;
import pl.kasprowski.etcal.dataunits.DataUnits;
import pl.kasprowski.etcal.dataunits.Target;
import pl.kasprowski.etcal.evaluation.Errors;
import pl.kasprowski.etcal.evaluation.Evaluator;
import pl.kasprowski.etcal.filters.Filter;
import pl.kasprowski.etcal.helpers.ObjDef;
import pl.kasprowski.etcal.helpers.ObjectBuilder;
import pl.kasprowski.etcal.mapper.MapTargets;
import pl.kasprowski.etcal.mapper.Mapper;
import pl.kasprowski.etcal.optimizer.AbstractOptimizer;
import pl.kasprowski.etcal.optimizer.Optimizer;

public class ETCal
implements IETCal,
AutoCloseable {
    static Set<ETCal> etcals = new HashSet<ETCal>();
    Logger log = Logger.getLogger(ETCal.class);
    private DataUnits dataUnits = new DataUnits();
    private List<Filter> filters = new ArrayList<Filter>();
    private Map<String, String> info = new HashMap<String, String>();
    private Calibrator best;
    private Optimizer optimizer;
    private List<Integer> mappings = new ArrayList<Integer>();
    private ExecutorService pool = Executors.newFixedThreadPool(10);
    private Future<Void> calibrationProcess;
    private Future<Void> optimizationProcess;
    private Future<Void> mappingProcess;

    public static ETCal getInstance() {
        ETCal e = new ETCal();
        etcals.add(e);
        return e;
    }

    public static void clean() {
        for (ETCal e : etcals) {
            e.close();
        }
    }

    public List<Integer> getMappings() {
        return this.mappings;
    }

    @Override
    public void add(DataUnits dataUnits) {
        this.dataUnits.add(dataUnits);
        this.log.debug((Object)("Added " + dataUnits.getDataUnits().size() + " data units"));
        this.log.trace((Object)("Total number of data units: " + this.dataUnits.getDataUnits().size()));
        this.info.put("dataUnits", "" + this.dataUnits.getDataUnits().size());
    }

    @Override
    public void reset() {
        this.dataUnits = new DataUnits();
        this.log.debug((Object)"Removed all data units");
        this.info.remove("dataUnits");
        this.pool.shutdown();
        this.pool = Executors.newFixedThreadPool(10);
        this.log.debug((Object)"Threads recreated");
    }

    @Override
    public void addFilter(ObjDef params) {
        try {
            Filter filter = (Filter)ObjectBuilder.getObjectFromObjDef(params);
            this.addFilter(filter);
        }
        catch (Exception e) {
            throw new ETCalException(String.valueOf(e.getClass().getName()) + ":" + e.getMessage(), e);
        }
    }

    @Override
    public void addFilter(Filter calFilter) {
        this.filters.add(calFilter);
        this.log.debug((Object)("Added " + calFilter + " filter"));
        this.info.put("filtersNum", "" + this.filters.size());
        this.info.put("filters", "" + this.filters);
    }

    @Override
    public void resetFilters() {
        this.filters = new ArrayList<Filter>();
        this.log.debug((Object)"All filters removed");
        this.info.remove("filtersNum");
        this.info.remove("filters");
    }

    @Override
    public void useFilter(ObjDef params) {
        try {
            Filter filter = (Filter)ObjectBuilder.getObjectFromObjDef(params);
            this.useFilter(filter);
        }
        catch (Exception e) {
            throw new ETCalException(String.valueOf(e.getClass().getName()) + ":" + e.getMessage(), e);
        }
    }

    @Override
    public void useFilter(Filter calFilter) {
        this.dataUnits = calFilter.filter(this.dataUnits);
        this.log.debug((Object)("Applied " + calFilter + " filter"));
    }

    @Override
    public void build(ObjDef params) {
        try {
            this.calibrationProcess = this.buildAsync(params, null);
            this.calibrationProcess.get();
        }
        catch (Exception e) {
            throw new ETCalException(String.valueOf(e.getClass().getName()) + ":" + e.getMessage(), e);
        }
    }

    @Override
    public Future<Void> buildAsync(ObjDef params, Callback callback) {
        if (this.dataUnits.size() == 0) {
            throw new ETCalException("No dataUnits: use add method to add training data!", null);
        }
        try {
            Calibrator calibrator = (Calibrator)ObjectBuilder.getObjectFromObjDef(params);
            return this.buildAsync(calibrator, callback);
        }
        catch (Exception e) {
            throw new ETCalException(String.valueOf(e.getClass().getName()) + ":" + e.getMessage(), e);
        }
    }

    @Override
    public void build(Calibrator calibrator) {
        try {
            this.calibrationProcess = this.buildAsync(calibrator, null);
            this.calibrationProcess.get();
        }
        catch (Exception e) {
            throw new ETCalException(String.valueOf(e.getClass().getName()) + ":" + e.getMessage(), e);
        }
    }

    @Override
    public Future<Void> buildAsync(final Calibrator calibrator, final Callback callback) {
        try {
            if (this.calibrationProcess != null && !this.calibrationProcess.isDone()) {
                this.log.warn((Object)"Terminating the previous calibration process");
                this.calibrationProcess.cancel(true);
            }
            this.calibrationProcess = this.pool.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ETCal.this.info.put("calibrationPending", "true");
                    ETCal.this.log.trace((Object)("Filtering with " + ETCal.this.filters.size() + " filters"));
                    DataUnits datau = ETCal.this.dataUnits;
                    for (Filter filter : ETCal.this.filters) {
                        ETCal.this.log.trace((Object)("Applying " + filter.getClass().getName() + " filter"));
                        datau = filter.filter(datau);
                    }
                    datau = MapTargets.mapTargets(datau, ETCal.this.mappings);
                    ETCal.this.log.trace((Object)("Building calibrator " + calibrator));
                    long startCalibration = System.currentTimeMillis();
                    calibrator.calculate(datau);
                    ETCal.this.best = calibrator;
                    ETCal.this.info.put("calibrator", ETCal.this.best.toString());
                    ETCal.this.info.put("calibrationTime", "" + (System.currentTimeMillis() - startCalibration));
                    ETCal.this.log.trace((Object)("Calibrator " + ETCal.this.best.getClass().getName() + " built"));
                    ETCal.this.log.trace((Object)("Calibration finished in " + (System.currentTimeMillis() - startCalibration) + " ms"));
                    if (callback != null) {
                        callback.ready();
                    }
                    ETCal.this.info.remove("calibrationPending");
                    return null;
                }
            });
            return this.calibrationProcess;
        }
        catch (Exception e) {
            throw new ETCalException(String.valueOf(e.getClass().getName()) + ":" + e.getMessage(), e);
        }
    }

    @Override
    public Target get(double[] data) {
        try {
            if (this.optimizationProcess != null && !this.optimizationProcess.isDone() && this.optimizer.getBest() != null) {
                this.best = this.optimizer.getBest();
                this.info.put("calibrator", this.best.toString());
                this.info.remove("calibrationTime");
            }
            if (this.best != null) {
                return this.best.getValue(data);
            }
        }
        catch (Exception e) {
            throw new ETCalException(String.valueOf(e.getClass().getName()) + ":" + e.getMessage(), e);
        }
        return null;
    }

    @Override
    public DataUnits get(DataUnits dataUnitsToCalibrate) {
        block5: {
            if (this.optimizationProcess != null && !this.optimizationProcess.isDone() && this.optimizer.getBest() != null) {
                this.best = this.optimizer.getBest();
                this.info.put("calibrator", this.best.toString());
                this.info.remove("calibrationTime");
            }
            if (this.best != null) break block5;
            return null;
        }
        try {
            RegressionData testData = DU2RDConverter.dataUnits2RegressionData(dataUnitsToCalibrate);
            DataUnits calibrated = new DataUnits();
            for (double[] x : testData.getX()) {
                Target p = this.best.getValue(x);
                DataUnit du = new DataUnit();
                du.addVariables(x);
                du.addTarget(p);
                calibrated.add(du);
            }
            return calibrated;
        }
        catch (Exception e) {
            throw new ETCalException(String.valueOf(e.getClass().getName()) + ":" + e.getMessage(), e);
        }
    }

    @Override
    public Errors checkErrors(DataUnits testUnits) {
        try {
            DataUnits datau = null;
            datau = this.dataUnits.clone();
            datau = MapTargets.mapTargets(datau, this.mappings);
            if (this.optimizationProcess != null && !this.optimizationProcess.isDone() && this.optimizer.getBest() != null) {
                this.best = this.optimizer.getBest();
                this.info.put("calibrator", this.best.toString());
                this.info.remove("calibrationTime");
            }
            Evaluator e = new Evaluator();
            return e.calculate(this.best, datau, testUnits);
        }
        catch (Exception e) {
            throw new ETCalException(String.valueOf(e.getClass().getName()) + ":" + e.getMessage(), e);
        }
    }

    @Override
    public void optimize(ObjDef params) {
        try {
            this.optimizationProcess = this.optimizeAsync(params, null);
            this.optimizationProcess.get();
        }
        catch (Exception e) {
            throw new ETCalException(String.valueOf(e.getClass().getName()) + ":" + e.getMessage(), e);
        }
    }

    @Override
    public Future<Void> optimizeAsync(ObjDef params, Callback callback) {
        try {
            this.optimizer = (AbstractOptimizer)ObjectBuilder.getObjectFromObjDef(params);
            return this.optimizeAsync(this.optimizer, callback);
        }
        catch (Exception e) {
            throw new ETCalException(String.valueOf(e.getClass().getName()) + ":" + e.getMessage(), e);
        }
    }

    @Override
    public void optimize(Optimizer optimizer) {
        try {
            this.optimizationProcess = this.optimizeAsync(optimizer, null);
            this.optimizationProcess.get();
        }
        catch (Exception e) {
            throw new ETCalException(String.valueOf(e.getClass().getName()) + ":" + e.getMessage(), e);
        }
    }

    @Override
    public Future<Void> optimizeAsync(final Optimizer optimizer, final Callback callback) {
        try {
            this.optimizer = optimizer;
            this.optimizationProcess = this.pool.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ETCal.this.info.put("optimizationPending", "true");
                    long startOptimization = System.currentTimeMillis();
                    ETCal.this.log.trace((Object)"Optimization start");
                    ETCal.this.log.trace((Object)("Filtering with " + ETCal.this.filters.size() + " filters"));
                    DataUnits datau = ETCal.this.dataUnits;
                    for (Filter filter : ETCal.this.filters) {
                        ETCal.this.log.trace((Object)("Applying " + filter.getClass().getName() + " filter"));
                        datau = filter.filter(datau);
                    }
                    try {
                        datau = MapTargets.mapTargets(datau, ETCal.this.mappings);
                        optimizer.optimize(datau);
                        ETCal.this.best = optimizer.getBest();
                        ETCal.this.info.put("calibrator", ETCal.this.best.toString());
                        ETCal.this.log.debug((Object)("Optimization finished in " + (System.currentTimeMillis() - startOptimization) + " ms"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ETCal.this.log.error((Object)("Optimization finished with " + e.getMessage() + " in " + (System.currentTimeMillis() - startOptimization) + " ms"));
                    }
                    ETCal.this.info.put("optimizationTime", "" + (System.currentTimeMillis() - startOptimization));
                    if (callback != null) {
                        callback.ready();
                    }
                    ETCal.this.info.remove("optimizationPending");
                    return null;
                }
            });
            return this.optimizationProcess;
        }
        catch (Exception e) {
            throw new ETCalException(String.valueOf(e.getClass().getName()) + ":" + e.getMessage(), e);
        }
    }

    @Override
    public void mapTargets(ObjDef params) {
        try {
            this.mappingProcess = this.mapTargetsAsync(params, null);
            this.mappingProcess.get();
        }
        catch (Exception e) {
            throw new ETCalException(String.valueOf(e.getClass().getName()) + ":" + e.getMessage(), e);
        }
    }

    @Override
    public Future<Void> mapTargetsAsync(ObjDef params, Callback callback) {
        try {
            Mapper mapper = (Mapper)ObjectBuilder.getObjectFromObjDef(params);
            return this.mapTargetsAsync(mapper, callback);
        }
        catch (Exception e) {
            throw new ETCalException(String.valueOf(e.getClass().getName()) + ":" + e.getMessage(), e);
        }
    }

    @Override
    public void mapTargets(Mapper mapper) {
        try {
            this.mappingProcess = this.mapTargetsAsync(mapper, null);
            this.mappingProcess.get();
        }
        catch (Exception e) {
            throw new ETCalException(String.valueOf(e.getClass().getName()) + ":" + e.getMessage(), e);
        }
    }

    @Override
    public Future<Void> mapTargetsAsync(final Mapper mapper, final Callback callback) {
        try {
            this.mappingProcess = this.pool.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ETCal.this.info.put("mappingPending", "true");
                    long startMapping = System.currentTimeMillis();
                    ETCal.this.log.trace((Object)"Mapping start");
                    try {
                        try {
                            ETCal.this.mappings = mapper.map(ETCal.this.dataUnits);
                            ETCal.this.log.trace((Object)("Mapping finished in " + (System.currentTimeMillis() - startMapping) + " ms"));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            ETCal.this.log.error((Object)("Mapping finished with " + e.getMessage() + " in " + (System.currentTimeMillis() - startMapping) + " ms"));
                            throw e;
                        }
                    }
                    finally {
                        ETCal.this.info.put("mappingTime", "" + (System.currentTimeMillis() - startMapping));
                        if (callback != null) {
                            callback.ready();
                        }
                        ETCal.this.info.remove("mappingPending");
                    }
                    return null;
                }
            });
            return this.mappingProcess;
        }
        catch (Exception e) {
            throw new ETCalException(String.valueOf(e.getClass().getName()) + ":" + e.getMessage(), e);
        }
    }

    @Override
    public Map<String, String> getStatusInfo() {
        return this.info;
    }

    @Override
    public String getStatusInfoJSON() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson(this.info);
    }

    @Override
    public boolean isCalibrating() {
        return this.calibrationProcess != null && !this.calibrationProcess.isDone();
    }

    @Override
    public boolean isOptimizing() {
        return this.optimizationProcess != null && !this.optimizationProcess.isDone();
    }

    @Override
    public boolean isMapping() {
        return this.mappingProcess != null && !this.mappingProcess.isDone();
    }

    @Override
    public void close() {
        this.reset();
    }
}

