/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal;

import java.util.Map;
import java.util.concurrent.Future;
import pl.kasprowski.etcal.Callback;
import pl.kasprowski.etcal.calibration.Calibrator;
import pl.kasprowski.etcal.dataunits.DataUnits;
import pl.kasprowski.etcal.dataunits.Target;
import pl.kasprowski.etcal.evaluation.Errors;
import pl.kasprowski.etcal.filters.Filter;
import pl.kasprowski.etcal.helpers.ObjDef;
import pl.kasprowski.etcal.mapper.Mapper;
import pl.kasprowski.etcal.optimizer.Optimizer;

public interface IETCal {
    public void add(DataUnits var1);

    public void reset();

    public void addFilter(ObjDef var1);

    public void addFilter(Filter var1);

    public void resetFilters();

    public void useFilter(ObjDef var1);

    public void useFilter(Filter var1);

    public void build(ObjDef var1);

    public Future<Void> buildAsync(ObjDef var1, Callback var2);

    public void build(Calibrator var1);

    public Future<Void> buildAsync(Calibrator var1, Callback var2);

    public Target get(double[] var1);

    public DataUnits get(DataUnits var1);

    public Errors checkErrors(DataUnits var1);

    public void optimize(ObjDef var1);

    public Future<Void> optimizeAsync(ObjDef var1, Callback var2);

    public void optimize(Optimizer var1);

    public Future<Void> optimizeAsync(Optimizer var1, Callback var2);

    public void mapTargets(ObjDef var1);

    public Future<Void> mapTargetsAsync(ObjDef var1, Callback var2);

    public void mapTargets(Mapper var1);

    public Future<Void> mapTargetsAsync(Mapper var1, Callback var2);

    public Map<String, String> getStatusInfo();

    public String getStatusInfoJSON();

    public boolean isCalibrating();

    public boolean isOptimizing();

    public boolean isMapping();
}

