/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.calibration;

import pl.kasprowski.etcal.calibration.CalibratorWeka;
import pl.kasprowski.etcal.dataunits.DataUnits;
import weka.classifiers.Classifier;
import weka.classifiers.functions.LibSVM;
import weka.core.SelectedTag;

public class CalibratorLibSVM
extends CalibratorWeka {
    private Integer expCost = -1;
    private Integer expGamma = 2;

    public void setExpCost(Integer cost) {
        this.expCost = cost;
    }

    public void setExpGamma(Integer gamma) {
        this.expGamma = gamma;
    }

    @Override
    public void calculate(DataUnits dataUnits) {
        LibSVM svm = new LibSVM();
        svm.setSVMType(new SelectedTag(4, LibSVM.TAGS_SVMTYPE));
        svm.setKernelType(new SelectedTag(2, LibSVM.TAGS_KERNELTYPE));
        svm.setShrinking(false);
        svm.setCost(Math.pow(2.0, this.expCost.intValue()));
        svm.setGamma(Math.pow(2.0, this.expGamma.intValue()));
        this.classifierX = svm;
        try {
            this.classifierY = Classifier.makeCopy((Classifier)svm);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.calculate(dataUnits);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " expCost:" + this.expCost + " expGamma:" + this.expGamma;
    }
}

