/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.calibration;

import org.apache.commons.math3.analysis.DifferentiableMultivariateVectorFunction;
import org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.apache.commons.math3.optimization.PointVectorValuePair;
import org.apache.commons.math3.optimization.general.LevenbergMarquardtOptimizer;
import org.apache.log4j.Logger;
import pl.kasprowski.etcal.calibration.Calibrator;
import pl.kasprowski.etcal.calibration.RegressionData;
import pl.kasprowski.etcal.calibration.polynomial.MaskedPolynomialProblem;
import pl.kasprowski.etcal.calibration.polynomial.PolynomialProblem;
import pl.kasprowski.etcal.dataunits.DU2RDConverter;
import pl.kasprowski.etcal.dataunits.DataUnits;
import pl.kasprowski.etcal.dataunits.Target;

public class CalibratorPolynomial
implements Calibrator {
    Logger log = Logger.getLogger(CalibratorPolynomial.class);
    boolean calculated = false;
    int maxEval = 100;
    PolynomialProblem problem;
    double[] variablesX;
    double[] variablesY;
    private String mask;

    public void setMaxEval(Integer maxEval) {
        this.maxEval = maxEval;
    }

    public String getMask() {
        return this.mask;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    @Override
    public void calculate(DataUnits dataUnits) {
        RegressionData data = DU2RDConverter.dataUnits2RegressionData(dataUnits);
        if (this.mask == null) {
            StringBuffer bmask = new StringBuffer("");
            int i = 0;
            while (i < MaskedPolynomialProblem.termsNum(data.xNum())) {
                bmask.append("1");
                ++i;
            }
            this.mask = bmask.toString();
        }
        this.problem = new MaskedPolynomialProblem(data, MaskedPolynomialProblem.maskFromString(this.mask));
        this.calculated = false;
        try {
            this.calculate(data, 0);
            this.calculate(data, 1);
            this.calculated = true;
        }
        catch (TooManyEvaluationsException ex) {
            this.log.warn((Object)("Too many evaluations exception mask=" + this.mask));
        }
    }

    public void calculate(RegressionData data, int axis) {
        this.calculated = false;
        LevenbergMarquardtOptimizer optimizer = new LevenbergMarquardtOptimizer();
        int solutionSize = this.problem.termsNum();
        if (this.problem instanceof MaskedPolynomialProblem) {
            solutionSize = ((MaskedPolynomialProblem)this.problem).maskedNum();
        }
        double[] initialSolution = new double[solutionSize];
        int i = 0;
        while (i < initialSolution.length) {
            initialSolution[i] = 1.0;
            ++i;
        }
        this.log.trace((Object)"Start");
        PointVectorValuePair optimum = optimizer.optimize(this.maxEval, (DifferentiableMultivariateVectorFunction)this.problem, axis == 0 ? data.getY1().stream().mapToDouble(d -> d).toArray() : data.getY2().stream().mapToDouble(d -> d).toArray(), data.getWeights().stream().mapToDouble(d -> d).toArray(), initialSolution);
        this.log.trace((Object)"Done");
        if (axis == 0) {
            this.variablesX = optimum.getPoint();
        } else {
            this.variablesY = optimum.getPoint();
        }
    }

    public void showVariables() {
        double v;
        char var = 'A';
        this.log.trace((Object)"X:");
        double[] dArray = this.variablesX;
        int n = this.variablesX.length;
        int n2 = 0;
        while (n2 < n) {
            v = dArray[n2];
            char c = var;
            var = (char)(c + 1);
            this.log.trace((Object)(String.valueOf(c) + ": " + v));
            ++n2;
        }
        var = 'A';
        this.log.trace((Object)"Y:");
        dArray = this.variablesY;
        n = this.variablesY.length;
        n2 = 0;
        while (n2 < n) {
            v = dArray[n2];
            char c = var;
            var = (char)(c + '\u0001');
            this.log.trace((Object)(String.valueOf(c) + ": " + v));
            ++n2;
        }
    }

    @Override
    public Target getValue(double[] x) {
        if (!this.calculated) {
            throw new RuntimeException("Model not calculated!");
        }
        if (this.variablesX == null || this.variablesY == null) {
            throw new RuntimeException("Parameters not calculated yet!");
        }
        double sx = this.problem.value(x, this.variablesX);
        double sy = this.problem.value(x, this.variablesY);
        Target dv = new Target(sx, sy, 1.0);
        return dv;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " mask:" + this.getMask();
    }
}

