/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.calibration;

import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import pl.kasprowski.etcal.calibration.Calibrator;
import pl.kasprowski.etcal.calibration.RegressionData;
import pl.kasprowski.etcal.dataunits.DU2RDConverter;
import pl.kasprowski.etcal.dataunits.DataUnits;
import pl.kasprowski.etcal.dataunits.Target;
import weka.classifiers.Classifier;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class CalibratorWeka
implements Calibrator {
    boolean calculated = false;
    protected Classifier classifierX;
    Instances instancesX;
    protected Classifier classifierY;
    Instances instancesY;

    @Override
    public void calculate(DataUnits dataUnits) {
        RegressionData data = DU2RDConverter.dataUnits2RegressionData(dataUnits);
        this.calculated = false;
        System.setOut(new PrintStream(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        }));
        try {
            int j;
            Instance instance;
            double y;
            double[] x;
            FastVector attributes = new FastVector();
            attributes.addElement((Object)new Attribute("y"));
            int i = 0;
            while (i < data.xNum()) {
                attributes.addElement((Object)new Attribute("a" + i));
                ++i;
            }
            this.instancesX = new Instances("EyeX", attributes, 100);
            this.instancesX.setClassIndex(0);
            this.instancesY = new Instances("EyeY", attributes, 100);
            this.instancesY.setClassIndex(0);
            i = 0;
            while (i < data.size()) {
                x = data.getX().get(i);
                y = data.getY1().get(i);
                instance = new Instance(data.xNum() + 1);
                instance.setValue((Attribute)attributes.elementAt(0), y);
                j = 0;
                while (j < data.xNum()) {
                    instance.setValue((Attribute)attributes.elementAt(j + 1), x[j]);
                    ++j;
                }
                this.instancesX.add(instance);
                ++i;
            }
            i = 0;
            while (i < data.size()) {
                x = data.getX().get(i);
                y = data.getY2().get(i);
                instance = new Instance(data.xNum() + 1);
                instance.setValue((Attribute)attributes.elementAt(0), y);
                j = 0;
                while (j < data.xNum()) {
                    instance.setValue((Attribute)attributes.elementAt(j + 1), x[j]);
                    ++j;
                }
                this.instancesY.add(instance);
                ++i;
            }
            try {
                this.classifierX.buildClassifier(this.instancesX);
                this.classifierY.buildClassifier(this.instancesY);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println(this.instancesX);
            }
            this.calculated = true;
        }
        finally {
            System.setOut(new PrintStream(new FileOutputStream(FileDescriptor.out)));
        }
    }

    @Override
    public Target getValue(double[] x) {
        if (!this.calculated) {
            throw new RuntimeException("Model not calculated!");
        }
        double sx = this.getResult(x, this.classifierX);
        double sy = this.getResult(x, this.classifierY);
        Target dv = new Target(sx, sy, 1.0);
        return dv;
    }

    public double getResult(double[] x, Classifier classifier) {
        try {
            FastVector attributes = new FastVector();
            attributes.addElement((Object)new Attribute("y"));
            int i = 0;
            while (i < x.length) {
                attributes.addElement((Object)new Attribute("a" + i));
                ++i;
            }
            Instances instances = new Instances("EyeDB", attributes, 1);
            instances.setClassIndex(0);
            Instance instance = new Instance(x.length + 1);
            int i2 = 0;
            while (i2 < x.length) {
                instance.setValue((Attribute)attributes.elementAt(i2 + 1), x[i2]);
                ++i2;
            }
            instance.setDataset(instances);
            return classifier.classifyInstance(instance);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }
}

