/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.calibration;

import java.util.ArrayList;
import java.util.List;

public class RegressionData {
    List<double[]> x = new ArrayList<double[]>();
    List<Double> y1;
    List<Double> y2;
    List<Double> weights;

    public RegressionData() {
        this.reset();
    }

    public List<double[]> getX() {
        return this.x;
    }

    public List<Double> getY1() {
        return this.y1;
    }

    public List<Double> getY2() {
        return this.y2;
    }

    public List<Double> getWeights() {
        return this.weights;
    }

    public double[] getX(int i) {
        return this.x.get(i);
    }

    public Double getY1(int i) {
        return this.y1.get(i);
    }

    public Double getY2(int i) {
        return this.y2.get(i);
    }

    public Double getWeights(int i) {
        return this.weights.get(i);
    }

    public void reset() {
        this.x = new ArrayList<double[]>();
        this.y1 = new ArrayList<Double>();
        this.y2 = new ArrayList<Double>();
        this.weights = new ArrayList<Double>();
    }

    public int size() {
        return this.x.size();
    }

    public int xNum() {
        return this.x.get(0).length;
    }

    public void addPoint(double[] x, double y1, double y2, double weight) {
        this.x.add(x);
        this.y1.add(y1);
        this.y2.add(y2);
        this.weights.add(weight);
    }

    public static RegressionData merge(List<RegressionData> list) {
        RegressionData data = new RegressionData();
        for (RegressionData r : list) {
            int i = 0;
            while (i < r.size()) {
                data.addPoint(r.getX(i), r.getY1(i), r.getY2(i), r.getWeights(i));
                ++i;
            }
        }
        return data;
    }
}

