/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.calibration.polynomial;

import pl.kasprowski.etcal.calibration.RegressionData;
import pl.kasprowski.etcal.calibration.polynomial.PolynomialProblem;

public class MaskedPolynomialProblem
extends PolynomialProblem {
    private boolean[] mask;
    private int termsNum = -1;

    public MaskedPolynomialProblem(RegressionData data, boolean[] mask) {
        this.data = data;
        this.mask = mask;
    }

    public void setMask(boolean[] mask) {
        this.mask = mask;
    }

    public boolean[] getMask() {
        return this.mask;
    }

    public int maskedNum() {
        int x = 0;
        boolean[] blArray = this.mask;
        int n = this.mask.length;
        int n2 = 0;
        while (n2 < n) {
            boolean b = blArray[n2];
            if (b) {
                ++x;
            }
            ++n2;
        }
        return x;
    }

    @Override
    public int termsNum() {
        if (this.termsNum == -1) {
            this.termsNum = MaskedPolynomialProblem.termsNum(this.data.xNum());
        }
        return this.termsNum;
    }

    public static int termsNum(int xNum) {
        int termsNum = MaskedPolynomialProblem.komb(xNum, 3) + MaskedPolynomialProblem.komb(xNum, 2) + xNum + 1;
        return termsNum;
    }

    @Override
    public double value(double[] x, double[] variables) {
        String[] v = MaskedPolynomialProblem.fillV(this.termsNum, this.data.xNum());
        double retValue = 0.0;
        int vn = 0;
        int i = 0;
        while (i < v.length - 1) {
            if (this.mask[i]) {
                double term = variables[vn];
                int k = 0;
                while (k < v[i].length()) {
                    int ind = Integer.valueOf(v[i].substring(k, k + 1));
                    term *= x[ind];
                    ++k;
                }
                retValue += term;
                ++vn;
            }
            ++i;
        }
        return retValue += variables[this.maskedNum() - 1];
    }

    @Override
    double[][] jacobian(double[] variables) {
        double[][] jacobian = new double[this.data.size()][this.maskedNum()];
        String[] v = MaskedPolynomialProblem.fillV(this.termsNum, this.data.xNum());
        int i = 0;
        while (i < jacobian.length) {
            int m = 0;
            double[] x = this.data.getX().get(i);
            int j = 0;
            while (j < v.length - 1) {
                if (this.mask[j]) {
                    double term = 1.0;
                    int k = 0;
                    while (k < v[j].length()) {
                        int ind = Integer.valueOf(v[j].substring(k, k + 1));
                        term *= x[ind];
                        ++k;
                    }
                    jacobian[i][m] = term;
                    ++m;
                }
                ++j;
            }
            jacobian[i][this.maskedNum() - 1] = 1.0;
            ++i;
        }
        return jacobian;
    }

    static String[] fillV(int varsNum, int xnum) {
        int k;
        String[] v = new String[varsNum];
        int j = 0;
        int i = 0;
        while (i < xnum) {
            k = i;
            while (k < xnum) {
                int m = k;
                while (m < xnum) {
                    v[j++] = String.valueOf(i) + k + m;
                    ++m;
                }
                ++k;
            }
            ++i;
        }
        i = 0;
        while (i < xnum) {
            k = i;
            while (k < xnum) {
                v[j++] = String.valueOf(i) + k;
                ++k;
            }
            ++i;
        }
        i = 0;
        while (i < xnum) {
            v[j++] = "" + i;
            ++i;
        }
        v[j++] = "W";
        return v;
    }

    public static int komb(int n, int k) {
        return MaskedPolynomialProblem.factorial(n + k - 1) / (MaskedPolynomialProblem.factorial(k) * MaskedPolynomialProblem.factorial(n - 1));
    }

    static int factorial(int n) {
        int fact = 1;
        int i = 1;
        while (i <= n) {
            fact *= i;
            ++i;
        }
        return fact;
    }

    public static String maskAsString(boolean[] mask) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < mask.length) {
            sb.append(mask[i] ? "1" : "0");
            ++i;
        }
        return sb.toString();
    }

    public static boolean[] maskFromString(String txt) {
        boolean[] mask = new boolean[txt.length()];
        int i = 0;
        while (i < txt.length()) {
            mask[i] = txt.substring(i, i + 1).equals("1");
            ++i;
        }
        return mask;
    }
}

