/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.calibration.polynomial;

import java.util.List;
import org.apache.commons.math3.analysis.DifferentiableMultivariateVectorFunction;
import org.apache.commons.math3.analysis.MultivariateMatrixFunction;
import pl.kasprowski.etcal.calibration.RegressionData;

public abstract class PolynomialProblem
implements DifferentiableMultivariateVectorFunction {
    RegressionData data;

    public void setData(RegressionData data) {
        this.data = data;
    }

    public abstract int termsNum();

    public abstract double value(double[] var1, double[] var2);

    abstract double[][] jacobian(double[] var1);

    public double[] value(List<double[]> x, double[] variables) {
        double[] values = new double[x.size()];
        int i = 0;
        while (i < values.length) {
            values[i] = this.value(x.get(i), variables);
            ++i;
        }
        return values;
    }

    public double[] value(double[] variables) throws IllegalArgumentException {
        return this.value(this.data.getX(), variables);
    }

    public MultivariateMatrixFunction jacobian() {
        return new MultivariateMatrixFunction(){

            public double[][] value(double[] point) {
                return PolynomialProblem.this.jacobian(point);
            }
        };
    }
}

