/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.dataunits;

import java.util.ArrayList;
import java.util.List;
import pl.kasprowski.etcal.dataunits.Target;

public class DataUnit {
    private List<Double> variables = new ArrayList<Double>();
    private List<Target> targets = new ArrayList<Target>();
    private String info;
    private long timestamp;

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void addVariable(Double x) {
        this.variables.add(x);
    }

    public void addVariables(double[] x) {
        double[] dArray = x;
        int n = x.length;
        int n2 = 0;
        while (n2 < n) {
            double v = dArray[n2];
            this.addVariable(v);
            ++n2;
        }
    }

    public void addVariables(List<Double> x) {
        for (double v : x) {
            this.addVariable(v);
        }
    }

    public void addTarget(Target t) {
        this.targets.add(t);
    }

    public int getSize() {
        return this.variables.size();
    }

    public List<Target> getTargets() {
        return this.targets;
    }

    public List<Double> getVariables() {
        return this.variables;
    }

    public double[] getVariablesAsTable() {
        double[] t = new double[this.variables.size()];
        int i = 0;
        for (Double v : this.variables) {
            t[i++] = v;
        }
        return t;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Variables:");
        for (Double d : this.variables) {
            sb.append(d + ";");
        }
        sb.append("\tTargets:");
        for (Target target : this.targets) {
            sb.append(target);
        }
        return sb.toString();
    }
}

