/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.dataunits;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import pl.kasprowski.etcal.dataunits.DataUnit;
import pl.kasprowski.etcal.dataunits.Target;

public class DataUnits
implements Cloneable {
    private List<DataUnit> dataUnits = new ArrayList<DataUnit>();

    public int size() {
        return this.dataUnits.size();
    }

    public int xNum() {
        return this.dataUnits.get(0).getSize();
    }

    public String toString() {
        return this.dataUnits.toString();
    }

    public void add(DataUnit du) {
        this.dataUnits.add(du);
    }

    public List<DataUnit> getDataUnits() {
        return this.dataUnits;
    }

    public void save(String fname) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileWriter writer = new FileWriter(fname);){
                this.save(writer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new RuntimeException("File " + fname + " not saved!");
        }
    }

    public void save(Writer writer) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        gson.toJson((Object)this, (Appendable)writer);
    }

    public static DataUnits load(String fname) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(new File(fname)));){
                return DataUnits.load(reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ie) {
            ie.printStackTrace();
            throw new RuntimeException("File " + fname + " not loaded!");
        }
    }

    public static DataUnits load(BufferedReader reader) {
        Gson gson = new GsonBuilder().create();
        DataUnits du = (DataUnits)gson.fromJson((Reader)reader, DataUnits.class);
        return du;
    }

    public void add(DataUnits dus) {
        for (DataUnit du : dus.getDataUnits()) {
            this.getDataUnits().add(du);
        }
    }

    public DataUnits clone() {
        DataUnits newDu = new DataUnits();
        for (DataUnit u : this.dataUnits) {
            DataUnit newd = new DataUnit();
            newd.addVariables(u.getVariables());
            for (Target t : u.getTargets()) {
                newd.addTarget(new Target(t.getX(), t.getY(), t.getW()));
            }
            newDu.add(newd);
        }
        return newDu;
    }
}

