/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.evaluation;

import java.util.List;
import pl.kasprowski.etcal.dataunits.Target;

public class CalcErrors {
    private static double coefX = 1.0;
    private static double coefY = 1.0;

    public double[] calcErrors(List<Target> real, List<Target> calib) {
        double[] realX = new double[real.size()];
        double[] realY = new double[real.size()];
        int i = 0;
        while (i < real.size()) {
            realX[i] = real.get(i).getX();
            realY[i] = real.get(i).getY();
            ++i;
        }
        double[] calibX = new double[calib.size()];
        double[] calibY = new double[calib.size()];
        int i2 = 0;
        while (i2 < calib.size()) {
            calibX[i2] = calib.get(i2).getX();
            calibY[i2] = calib.get(i2).getY();
            ++i2;
        }
        return this.calcErrors(realX, calibX, realY, calibY);
    }

    public double[] calcErrors(double[] sx, double[] xc, double[] sy, double[] yc) {
        double[] r = new double[]{this.calcRSquare(sx, xc), this.calcRSquare(sy, yc), this.calcMSE(sx, xc), this.calcMSE(sy, yc), CalcErrors.calcAbsError(sx, xc, sy, yc, 1.0, 1.0), CalcErrors.calcError(sx, xc, coefX), CalcErrors.calcError(sy, yc, coefY), CalcErrors.calcAbsError(sx, xc, sy, yc, coefX, coefY)};
        return r;
    }

    public double calcRSquare(double[] sx, double[] xc) {
        double sumx = 0.0;
        int i = 0;
        while (i < sx.length) {
            sumx += sx[i];
            ++i;
        }
        double avgx = sumx / (double)sx.length;
        double res = 0.0;
        double tot = 0.0;
        int i2 = 0;
        while (i2 < sx.length) {
            res += (sx[i2] - xc[i2]) * (sx[i2] - xc[i2]);
            tot += (sx[i2] - avgx) * (sx[i2] - avgx);
            ++i2;
        }
        double rsq = 1.0 - res / tot;
        return rsq;
    }

    private double calcMSE(double[] sx, double[] xc) {
        double sse = 0.0;
        int i = 0;
        while (i < sx.length) {
            sse += (sx[i] - xc[i]) * (sx[i] - xc[i]);
            ++i;
        }
        double mse = sse / (double)sx.length;
        return Math.sqrt(mse);
    }

    public static double calcError(double[] x, double[] xc, double coef) {
        double sumErr = 0.0;
        int i = 0;
        while (i < x.length) {
            double dx = (x[i] - xc[i]) * coef;
            sumErr += Math.abs(dx);
            ++i;
        }
        return sumErr / (double)x.length;
    }

    public static double calcAbsError(double[] x, double[] xc, double[] y, double[] yc, double coefX, double coefY) {
        double sumErr = 0.0;
        int i = 0;
        while (i < x.length) {
            double dx = (x[i] - xc[i]) * coefX;
            double dy = (y[i] - yc[i]) * coefY;
            sumErr += Math.sqrt(dx * dx + dy * dy);
            ++i;
        }
        return sumErr / (double)x.length;
    }
}

