/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.evaluation;

import java.util.ArrayList;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import pl.kasprowski.etcal.calibration.Calibrator;
import pl.kasprowski.etcal.calibration.RegressionData;
import pl.kasprowski.etcal.dataunits.DU2RDConverter;
import pl.kasprowski.etcal.dataunits.DataUnits;
import pl.kasprowski.etcal.dataunits.Target;
import pl.kasprowski.etcal.evaluation.CalcErrors;
import pl.kasprowski.etcal.evaluation.Errors;

public class Evaluator {
    static Logger log = Logger.getLogger(Evaluator.class);

    static {
        log.setLevel(Level.ERROR);
    }

    public Errors calculate(Calibrator c, DataUnits data) {
        return this.calculate(c, data, data);
    }

    public Errors calculate(Calibrator c, DataUnits dataUnits, int foldsNo, int cvType) {
        int i;
        if (foldsNo == 0) {
            log.error((Object)("foldsNo = " + foldsNo));
            throw new RuntimeException("foldsNo = " + foldsNo);
        }
        if (foldsNo == 1) {
            return this.calculate(c, dataUnits, dataUnits);
        }
        RegressionData data = DU2RDConverter.dataUnits2RegressionData(dataUnits);
        ArrayList<RegressionData> folds = new ArrayList<RegressionData>();
        int i2 = 0;
        while (i2 < foldsNo) {
            folds.add(new RegressionData());
            ++i2;
        }
        if (cvType == 0) {
            int currentFold = 0;
            i = 0;
            while (i < data.size()) {
                ((RegressionData)folds.get(currentFold)).addPoint(data.getX(i), data.getY1(i), data.getY2(i), data.getWeights(i));
                currentFold = (currentFold + 1) % foldsNo;
                ++i;
            }
        } else {
            int singleFoldSize = data.size() / folds.size();
            i = 0;
            while (i < folds.size()) {
                int j = 0;
                while (j < singleFoldSize) {
                    int offset = singleFoldSize * i;
                    ((RegressionData)folds.get(i)).addPoint(data.getX(offset + j), data.getY1(offset + j), data.getY2(offset + j), data.getWeights(offset + j));
                    ++j;
                }
                ++i;
            }
        }
        i2 = 0;
        while (i2 < foldsNo) {
            log.trace((Object)(String.valueOf(i2) + " > " + ((RegressionData)folds.get(i2)).size()));
            ++i2;
        }
        ArrayList<Errors> le = new ArrayList<Errors>();
        i = 0;
        while (i < foldsNo) {
            ArrayList<RegressionData> trainingFolds = new ArrayList<RegressionData>(folds);
            trainingFolds.remove(i);
            RegressionData t = RegressionData.merge(trainingFolds);
            DataUnits duNoFold = DU2RDConverter.regressionData2dataUnits(t);
            DataUnits duFold = DU2RDConverter.regressionData2dataUnits((RegressionData)folds.get(i));
            Errors se = this.calculate(c, duNoFold, duFold);
            le.add(se);
            ++i;
        }
        return Errors.average(le);
    }

    public Errors calculate(Calibrator c, DataUnits trainData, DataUnits testData) {
        log.trace((Object)("trainSize: " + trainData.size() + " testSize: " + testData.size()));
        c.calculate(trainData);
        RegressionData rTestData = DU2RDConverter.dataUnits2RegressionData(testData);
        ArrayList<Target> realPts = new ArrayList<Target>();
        ArrayList<Target> calibPts = new ArrayList<Target>();
        int i = 0;
        while (i < testData.size()) {
            Target calPoint = c.getValue(rTestData.getX().get(i));
            Target realPoint = new Target(rTestData.getY1().get(i), rTestData.getY2().get(i), 1.0);
            realPts.add(realPoint);
            calibPts.add(calPoint);
            ++i;
        }
        CalcErrors ce = new CalcErrors();
        double[] e = ce.calcErrors(realPts, calibPts);
        Errors er = new Errors(e);
        return er;
    }
}

