/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.filters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import pl.kasprowski.etcal.calibration.RegressionData;
import pl.kasprowski.etcal.dataunits.DU2RDConverter;
import pl.kasprowski.etcal.dataunits.DataUnits;
import pl.kasprowski.etcal.filters.Filter;

public class AoiMedianizeFilter
implements Filter {
    private int minSize;

    public int getMinSize() {
        return this.minSize;
    }

    public void setMinSize(int minSize) {
        this.minSize = minSize;
    }

    @Override
    public DataUnits filter(DataUnits dataUnits) {
        RegressionData data = DU2RDConverter.dataUnits2RegressionData(dataUnits);
        RegressionData newdata = new RegressionData();
        Double lastY1 = null;
        Double lastY2 = null;
        ArrayList<Object> points = new ArrayList<double[]>();
        int i = 0;
        while (i < data.size()) {
            if (data.getY1(i).equals(lastY1) && data.getY2(i).equals(lastY2)) {
                points.add(data.getX(i));
            } else {
                if (points.size() > this.minSize) {
                    double[] p = this.medianize(points);
                    newdata.addPoint(p, lastY1, lastY2, points.size());
                }
                lastY1 = data.getY1(i);
                lastY2 = data.getY2(i);
                points = new ArrayList();
            }
            ++i;
        }
        if (points.size() > this.minSize) {
            double[] p = this.medianize(points);
            newdata.addPoint(p, lastY1, lastY2, points.size());
        }
        return DU2RDConverter.regressionData2dataUnits(newdata);
    }

    double[] medianize(List<double[]> points) {
        int size = points.get(0).length;
        double[] res = new double[size];
        int i = 0;
        while (i < size) {
            ArrayList<Double> lista = new ArrayList<Double>();
            for (double[] r : points) {
                lista.add(r[i]);
            }
            res[i] = AoiMedianizeFilter.median(lista);
            ++i;
        }
        return res;
    }

    public static double median(List<Double> x) {
        Collections.sort(x);
        return x.get(x.size() / 2);
    }
}

