/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.filters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import pl.kasprowski.etcal.dataunits.DataUnit;
import pl.kasprowski.etcal.dataunits.DataUnits;
import pl.kasprowski.etcal.dataunits.Target;
import pl.kasprowski.etcal.filters.Filter;

public class MedianFilter
implements Filter {
    int len;

    public MedianFilter setLen(int len) {
        this.len = len;
        return this;
    }

    @Override
    public DataUnits filter(DataUnits dataUnits) {
        DataUnit newDu;
        DataUnit oldDu;
        int size = dataUnits.getDataUnits().size();
        DataUnits newDataUnits = new DataUnits();
        int i = 0;
        while (i < this.len / 2) {
            oldDu = dataUnits.getDataUnits().get(i);
            newDu = new DataUnit();
            newDu.addVariables(oldDu.getVariables());
            for (Target t : oldDu.getTargets()) {
                newDu.addTarget(new Target(t.getX(), t.getY(), t.getW()));
            }
            newDataUnits.add(newDu);
            ++i;
        }
        i = this.len / 2;
        while (i < size - this.len / 2) {
            oldDu = dataUnits.getDataUnits().get(i);
            ArrayList<double[]> points = new ArrayList<double[]>();
            int j = -this.len / 2;
            while (j <= this.len / 2) {
                DataUnit oldDuX = dataUnits.getDataUnits().get(i + j);
                points.add(oldDuX.getVariablesAsTable());
                ++j;
            }
            double[] p = this.medianize(points);
            DataUnit newDu2 = new DataUnit();
            newDu2.addVariables(p);
            for (Target t : oldDu.getTargets()) {
                newDu2.addTarget(new Target(t.getX(), t.getY(), t.getW()));
            }
            newDataUnits.add(newDu2);
            ++i;
        }
        i = size - this.len / 2;
        while (i < size) {
            oldDu = dataUnits.getDataUnits().get(i);
            newDu = new DataUnit();
            newDu.addVariables(oldDu.getVariables());
            for (Target t : oldDu.getTargets()) {
                newDu.addTarget(new Target(t.getX(), t.getY(), t.getW()));
            }
            newDataUnits.add(newDu);
            ++i;
        }
        return newDataUnits;
    }

    double[] medianize(List<double[]> points) {
        int size = points.get(0).length;
        double[] res = new double[size];
        int i = 0;
        while (i < size) {
            ArrayList<Double> lista = new ArrayList<Double>();
            for (double[] r : points) {
                lista.add(r[i]);
            }
            res[i] = MedianFilter.median(lista);
            ++i;
        }
        return res;
    }

    public static double median(List<Double> x) {
        Collections.sort(x);
        return x.get(x.size() / 2);
    }
}

