/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.filters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import pl.kasprowski.etcal.dataunits.DataUnit;
import pl.kasprowski.etcal.dataunits.DataUnits;
import pl.kasprowski.etcal.dataunits.Target;
import pl.kasprowski.etcal.filters.Filter;

public class ReduceFilter
implements Filter {
    private int len;

    public int getLen() {
        return this.len;
    }

    public void setLen(int len) {
        this.len = len;
    }

    @Override
    public DataUnits filter(DataUnits dataUnits) {
        int size = dataUnits.getDataUnits().size();
        DataUnits newDataUnits = new DataUnits();
        DataUnit newDu = null;
        int i = 0;
        while (i < size - this.len - 1) {
            ArrayList<double[]> points = new ArrayList<double[]>();
            ArrayList<Double> y1 = new ArrayList<Double>();
            ArrayList<Double> y2 = new ArrayList<Double>();
            int j = i;
            while (j < i + this.len) {
                DataUnit oldDu = dataUnits.getDataUnits().get(j);
                points.add(oldDu.getVariablesAsTable());
                y1.add(oldDu.getTargets().get(0).getX());
                y2.add(oldDu.getTargets().get(0).getY());
                ++j;
            }
            double[] p = this.medianize(points);
            double ny1 = ReduceFilter.median(y1);
            double ny2 = ReduceFilter.median(y2);
            newDu = new DataUnit();
            newDu.addVariables(p);
            newDu.addTarget(new Target(ny1, ny2, 1.0));
            newDataUnits.add(newDu);
            i += this.len;
        }
        return newDataUnits;
    }

    double[] medianize(List<double[]> points) {
        int size = points.get(0).length;
        double[] res = new double[size];
        int i = 0;
        while (i < size) {
            ArrayList<Double> lista = new ArrayList<Double>();
            for (double[] r : points) {
                lista.add(r[i]);
            }
            res[i] = ReduceFilter.median(lista);
            ++i;
        }
        return res;
    }

    public static double median(List<Double> x) {
        Collections.sort(x);
        return x.get(x.size() / 2);
    }
}

