/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.helpers;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import pl.kasprowski.etcal.helpers.ObjDef;

public class ObjectBuilder {
    static Logger log = Logger.getLogger(ObjectBuilder.class);

    static {
        log.setLevel(Level.WARN);
    }

    public static Object getObjectFromObjDef(ObjDef objDef) {
        log.trace((Object)("Building object " + objDef.type + " with: " + objDef.params));
        Object o = null;
        try {
            o = Class.forName(objDef.type).newInstance();
            ObjectBuilder.runSetters(o, objDef.params);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Exception while creating class " + objDef.type);
        }
        return o;
    }

    private static void runSetters(Object o, Map<String, String> params) throws Exception {
        for (String key : params.keySet()) {
            String setterName = "set" + key.substring(0, 1).toUpperCase() + key.substring(1);
            Class<?> paramClass = ObjectBuilder.findParamClass(o, setterName);
            if (paramClass == null) {
                log.warn((Object)("No setter for parameter " + o.getClass().getName() + "." + setterName + " "));
                continue;
            }
            String txt = params.get(key);
            Object value = ObjectBuilder.convertStringToClass(txt, paramClass);
            System.out.println(value.getClass());
            try {
                Method mSet = o.getClass().getMethod(setterName, value.getClass());
                mSet.invoke(o, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static Class<?> findParamClass(Object obj, String metName) {
        Method[] methods;
        Class<?> c = obj.getClass();
        Method[] methodArray = methods = c.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equals(metName)) {
                return m.getParameterTypes()[0];
            }
            ++n2;
        }
        return null;
    }

    private static Object convertStringToClass(String txt, Class<?> clazz) {
        if (clazz.equals(String.class)) {
            return txt;
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return Integer.parseInt(txt);
        }
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            return Double.parseDouble(txt);
        }
        try {
            return Class.forName(txt).newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }
}

