/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.mapper.genetic;

import java.security.SecureRandom;
import pl.kasprowski.etcal.mapper.genetic.GeneticMapper;
import pl.kasprowski.etcal.mapper.genetic.Individual;
import pl.kasprowski.etcal.mapper.genetic.Population;

public class Algorithm {
    private static final double uniformRate = 0.5;
    private static final double mutationRate = 0.015;
    private static final int tournamentSize = 5;
    private static final boolean elitism = true;
    SecureRandom sr = new SecureRandom();
    GeneticMapper mapper;

    public Algorithm(GeneticMapper mapper) {
        this.mapper = mapper;
    }

    public Population evolvePopulation(Population pop) {
        int elitismOffset;
        Population newPopulation = new Population(pop.size(), false, this.mapper);
        newPopulation.saveIndividual(0, pop.getFittest());
        int i = elitismOffset = 1;
        while (i < pop.size()) {
            Individual indiv1 = this.tournamentSelection(pop);
            Individual indiv2 = this.tournamentSelection(pop);
            Individual newIndiv = this.crossover(indiv1, indiv2);
            newPopulation.saveIndividual(i, newIndiv);
            ++i;
        }
        i = elitismOffset;
        while (i < newPopulation.size()) {
            this.mutate(newPopulation.getIndividual(i));
            ++i;
        }
        return newPopulation;
    }

    private Individual crossover(Individual indiv1, Individual indiv2) {
        Individual newSol = new Individual(this.mapper);
        int i = 0;
        while (i < indiv1.size()) {
            if (Math.random() <= 0.5) {
                newSol.setGene(i, indiv1.getGene(i));
            } else {
                newSol.setGene(i, indiv2.getGene(i));
            }
            ++i;
        }
        return newSol;
    }

    private void mutate(Individual indiv) {
        int i = 0;
        while (i < indiv.size()) {
            if (Math.random() <= 0.015 && this.mapper.getMaxes().get(i) > 0) {
                int gene = this.sr.nextInt(this.mapper.getMaxes().get(i));
                indiv.setGene(i, gene);
            }
            ++i;
        }
    }

    private Individual tournamentSelection(Population pop) {
        Population tournament = new Population(5, false, this.mapper);
        int i = 0;
        while (i < 5) {
            int randomId = (int)(Math.random() * (double)pop.size());
            tournament.saveIndividual(i, pop.getIndividual(randomId));
            ++i;
        }
        Individual fittest = tournament.getFittest();
        return fittest;
    }
}

