/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.mapper.genetic;

import pl.kasprowski.etcal.calibration.CalibratorPolynomial;
import pl.kasprowski.etcal.calibration.RegressionData;
import pl.kasprowski.etcal.calibration.polynomial.MaskedPolynomialProblem;
import pl.kasprowski.etcal.dataunits.DU2RDConverter;
import pl.kasprowski.etcal.dataunits.DataUnits;
import pl.kasprowski.etcal.evaluation.Errors;
import pl.kasprowski.etcal.evaluation.Evaluator;
import pl.kasprowski.etcal.mapper.MapTargets;
import pl.kasprowski.etcal.mapper.genetic.FitnessCalc;
import pl.kasprowski.etcal.mapper.genetic.Individual;

public class FitnessDetermination2
implements FitnessCalc {
    @Override
    public double getFitness(Individual individual) {
        DataUnits datau = MapTargets.mapTargets(individual.getMapper().getDus(), individual.getGenes());
        RegressionData rData = DU2RDConverter.dataUnits2RegressionData(datau);
        StringBuffer bmask = new StringBuffer("");
        int i = 0;
        while (i < MaskedPolynomialProblem.termsNum(rData.xNum())) {
            bmask.append("0");
            ++i;
        }
        i = bmask.length() - rData.xNum() - 1;
        while (i < bmask.length()) {
            bmask.replace(i, i + 1, "1");
            ++i;
        }
        String mask = bmask.toString();
        CalibratorPolynomial calp = new CalibratorPolynomial();
        calp.setMask(mask);
        Evaluator e = new Evaluator();
        Errors errors = e.calculate(calp, datau, 1, 0);
        if (errors.getrSquareX().isNaN() || errors.getrSquareY().isNaN()) {
            return 0.0;
        }
        return errors.getrSquareX() * errors.getrSquareY();
    }

    @Override
    public String toString() {
        return "GEN-LIN";
    }
}

