/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.mapper.genetic;

import java.util.List;
import pl.kasprowski.etcal.dataunits.DataUnit;
import pl.kasprowski.etcal.dataunits.Target;
import pl.kasprowski.etcal.mapper.genetic.FitnessCalc;
import pl.kasprowski.etcal.mapper.genetic.Individual;
import pl.kasprowski.etcal.mapper.genetic.Point;

public class FitnessDist
implements FitnessCalc {
    @Override
    public double getFitness(Individual individual) {
        List<Integer> mappings = individual.getGenes();
        double fitness = 0.0;
        int i = 0;
        while (i < mappings.size() - 2) {
            int j = i + 1;
            while (j < mappings.size()) {
                int k = j + 1;
                while (k < mappings.size()) {
                    DataUnit dui = individual.getMapper().getDus().getDataUnits().get(i);
                    DataUnit duj = individual.getMapper().getDus().getDataUnits().get(j);
                    DataUnit duk = individual.getMapper().getDus().getDataUnits().get(k);
                    Target ti = dui.getTargets().get(mappings.get(i));
                    Target tj = duj.getTargets().get(mappings.get(j));
                    Target tk = duk.getTargets().get(mappings.get(k));
                    Target pi = new Target(dui.getVariables().get(0), dui.getVariables().get(1), 1.0);
                    Target pj = new Target(duj.getVariables().get(0), duj.getVariables().get(1), 1.0);
                    Target pk = new Target(duk.getVariables().get(0), duk.getVariables().get(1), 1.0);
                    double distTij = FitnessDist.dist(ti, tj);
                    double distTik = FitnessDist.dist(ti, tk);
                    double distPij = FitnessDist.dist(pi, pj);
                    double distPik = FitnessDist.dist(pi, pk);
                    double v1 = distTij / distTik;
                    double v2 = distPij / distPik;
                    if (v1 > 1.0 && v2 > 1.0 || v1 < 1.0 && v2 < 1.0) {
                        fitness += 1.0;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return fitness;
    }

    static double dist(Target v0, Target v1) {
        double x = v0.getX() - v1.getX();
        double y = v0.getY() - v1.getY();
        return Math.sqrt(x * x + y * y);
    }

    static double cosVect(Point v0, Point v1) {
        double scalar = v0.x * v1.x + v0.y * v1.y;
        double len0 = Math.sqrt(v0.x * v0.x + v0.y * v0.y);
        double len1 = Math.sqrt(v1.x * v1.x + v1.y * v1.y);
        return scalar / (len0 * len1);
    }

    @Override
    public String toString() {
        return "FC_DF";
    }
}

