/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.mapper.genetic;

import java.util.ArrayList;
import java.util.List;
import pl.kasprowski.etcal.mapper.genetic.FitnessCalc;
import pl.kasprowski.etcal.mapper.genetic.Individual;

public class FitnessFusion
implements FitnessCalc {
    List<FitnessCalc> fitnessCalcs = new ArrayList<FitnessCalc>();
    List<Double> weights = new ArrayList<Double>();

    public List<FitnessCalc> getFitnessCalcs() {
        return this.fitnessCalcs;
    }

    public void addFitnessCalc(FitnessCalc fc, double weight) {
        this.fitnessCalcs.add(fc);
        this.weights.add(weight);
    }

    public void removeFitnessCalc(int i) {
        this.fitnessCalcs.remove(i);
        this.weights.remove(i);
    }

    @Override
    public double getFitness(Individual individual) {
        double fitness = 0.0;
        int i = 0;
        while (i < this.fitnessCalcs.size()) {
            FitnessCalc fc = this.fitnessCalcs.get(i);
            fitness += fc.getFitness(individual) * this.weights.get(i);
            ++i;
        }
        return fitness;
    }

    @Override
    public String toString() {
        return "GEN-FUSION";
    }
}

