/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.mapper.genetic;

import pl.kasprowski.etcal.dataunits.DataUnit;
import pl.kasprowski.etcal.dataunits.Target;
import pl.kasprowski.etcal.mapper.genetic.FitnessCalc;
import pl.kasprowski.etcal.mapper.genetic.Individual;
import pl.kasprowski.etcal.mapper.genetic.Point;

public class FitnessSumCos
implements FitnessCalc {
    private boolean invertedX = false;

    public boolean isInvertedX() {
        return this.invertedX;
    }

    public void setInvertedX(boolean invertedX) {
        this.invertedX = invertedX;
    }

    @Override
    public double getFitness(Individual individual) {
        double fitness = 0.0;
        int i = 0;
        while (i < individual.getGenes().size() - 1) {
            int j = i + 1;
            while (j < individual.getGenes().size()) {
                int index0 = individual.getGene(i);
                DataUnit du0 = individual.getMapper().getDus().getDataUnits().get(i);
                Target t0 = du0.getTargets().get(index0);
                int index1 = individual.getGene(j);
                DataUnit du1 = individual.getMapper().getDus().getDataUnits().get(j);
                Target t1 = du1.getTargets().get(index1);
                Point vectTarget = new Point(t1.getX() - t0.getX(), t1.getY() - t0.getY());
                Target p0 = new Target(du0.getVariables().get(0), du0.getVariables().get(1), 1.0);
                Target p1 = new Target(du1.getVariables().get(0), du1.getVariables().get(1), 1.0);
                Point vectVars = null;
                vectVars = this.isInvertedX() ? new Point(p0.getX() - p1.getX(), p1.getY() - p0.getY()) : new Point(p1.getX() - p0.getX(), p1.getY() - p0.getY());
                if (!(vectTarget.x == 0.0 && vectTarget.y == 0.0 || vectVars.x == 0.0 && vectVars.y == 0.0)) {
                    fitness += FitnessSumCos.cosVect(vectTarget, vectVars);
                }
                ++j;
            }
            ++i;
        }
        return fitness;
    }

    static double cosVect(Point v0, Point v1) {
        double scalar = v0.x * v1.x + v0.y * v1.y;
        double len0 = Math.sqrt(v0.x * v0.x + v0.y * v0.y);
        double len1 = Math.sqrt(v1.x * v1.x + v1.y * v1.y);
        return scalar / (len0 * len1);
    }

    @Override
    public String toString() {
        return "GEN-SUMCOSFULL";
    }
}

