/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.mapper.genetic;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import pl.kasprowski.etcal.ETCalException;
import pl.kasprowski.etcal.dataunits.DataUnits;
import pl.kasprowski.etcal.mapper.Mapper;
import pl.kasprowski.etcal.mapper.genetic.Algorithm;
import pl.kasprowski.etcal.mapper.genetic.FitnessCalc;
import pl.kasprowski.etcal.mapper.genetic.FitnessSumCos;
import pl.kasprowski.etcal.mapper.genetic.Population;
import pl.kasprowski.etcal.optimizer.GeneticOptimizer;

public class GeneticMapper
implements Mapper,
GeneticOptimizer {
    Logger log = Logger.getLogger(GeneticMapper.class);
    private int genPopulation = 200;
    private int genIterations = 500;
    private int numIterationsWithNoProgress = 50;
    private int geneLength = 64;
    private List<Integer> maxes = new ArrayList<Integer>();
    private DataUnits dus;
    private FitnessCalc fitnessCalc = new FitnessSumCos();

    @Override
    public int getGenPopulation() {
        return this.genPopulation;
    }

    @Override
    public void setGenPopulation(Integer popSize) {
        this.genPopulation = popSize;
    }

    @Override
    public int getGenIterations() {
        return this.genIterations;
    }

    @Override
    public void setGenIterations(Integer iterations) {
        this.genIterations = iterations;
    }

    public int getNumIterationsWithNoProgress() {
        return this.numIterationsWithNoProgress;
    }

    public void setNumIterationsWithNoProgress(Integer numIterationsWithNoProgress) {
        this.numIterationsWithNoProgress = numIterationsWithNoProgress;
    }

    public int getGeneLength() {
        return this.geneLength;
    }

    public void setGeneLength(int length) {
        this.geneLength = length;
    }

    public DataUnits getDus() {
        return this.dus;
    }

    public void setDus(DataUnits dus) {
        this.dus = dus;
    }

    public FitnessCalc getFitnessCalc() {
        return this.fitnessCalc;
    }

    public void setFitnessCalc(FitnessCalc fitnessCalc) {
        this.fitnessCalc = fitnessCalc;
    }

    public List<Integer> getMaxes() {
        return this.maxes;
    }

    public void setMaxes(List<Integer> maxes) {
        this.maxes = maxes;
    }

    @Override
    public List<Integer> map(DataUnits dataUnits) throws Exception {
        if (this.fitnessCalc == null) {
            throw new ETCalException("No fitnessCalc function defined - use setFitnessCalc!", null);
        }
        int size = dataUnits.getDataUnits().size();
        ArrayList<Integer> maxes = new ArrayList<Integer>();
        int i = 0;
        while (i < size) {
            int max = dataUnits.getDataUnits().get(i).getTargets().size() - 1;
            if (max < 0) {
                System.err.println(String.valueOf(i) + ">" + dataUnits.getDataUnits().get(i).getTargets());
                throw new ETCalException("DataUnit [" + i + "] contains less than one target!", null);
            }
            maxes.add(max);
            ++i;
        }
        this.setGeneLength(size);
        this.setMaxes(maxes);
        this.setDus(dataUnits);
        Algorithm algorithm = new Algorithm(this);
        Population myPop = new Population(this.genPopulation, true, this);
        int generationCount = 0;
        double lastBestSolution = 0.0;
        int iterationsWithNoProgress = 0;
        while (generationCount < this.genIterations) {
            this.log.info((Object)("Generation: " + ++generationCount + " Fittest: " + myPop.getFittest().getFitness()));
            this.log.trace((Object)("Fittest: " + myPop.getFittest()));
            if (myPop.getFittest().getFitness() <= lastBestSolution) {
                ++iterationsWithNoProgress;
            } else {
                iterationsWithNoProgress = 0;
                lastBestSolution = myPop.getFittest().getFitness();
            }
            if (iterationsWithNoProgress > this.numIterationsWithNoProgress) {
                this.log.trace((Object)("No progress for " + iterationsWithNoProgress + " iterations - aborting"));
                break;
            }
            myPop = algorithm.evolvePopulation(myPop);
        }
        this.log.trace((Object)("Solution found in generation " + generationCount));
        this.log.trace((Object)("Genes: " + myPop.getFittest()));
        return myPop.getFittest().getGenes();
    }
}

