/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.mapper.genetic;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import pl.kasprowski.etcal.mapper.genetic.GeneticMapper;

public class Individual {
    SecureRandom sr = new SecureRandom();
    private List<Integer> genes = new ArrayList<Integer>();
    private double fitness = 0.0;
    private GeneticMapper mapper;

    public Individual(GeneticMapper mapper, List<Integer> genes) {
        this.mapper = mapper;
        this.genes = genes;
    }

    public GeneticMapper getMapper() {
        return this.mapper;
    }

    public Individual(GeneticMapper mapper) {
        this.mapper = mapper;
        this.generateIndividual();
    }

    public void generateIndividual() {
        this.genes = new ArrayList<Integer>();
        int i = 0;
        while (i < this.size()) {
            if (this.mapper.getMaxes().get(i) == 0) {
                this.genes.add(0);
            } else {
                int gene = this.sr.nextInt(this.mapper.getMaxes().get(i) + 1);
                this.genes.add(gene);
            }
            ++i;
        }
    }

    public int getGene(int index) {
        return this.genes.get(index);
    }

    public void setGene(int index, int value) {
        this.genes.set(index, value);
        this.fitness = 0.0;
    }

    public int size() {
        return this.mapper.getGeneLength();
    }

    public double getFitness() {
        if (this.fitness == 0.0) {
            this.fitness = this.mapper.getFitnessCalc().getFitness(this);
        }
        return this.fitness;
    }

    public String toString() {
        return this.genes.toString();
    }

    public List<Integer> getGenes() {
        return this.genes;
    }
}

