/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.mapper.genetic;

import pl.kasprowski.etcal.mapper.genetic.GeneticMapper;
import pl.kasprowski.etcal.mapper.genetic.Individual;

public class Population {
    Individual[] individuals;

    public Population(int populationSize, boolean initialise, GeneticMapper mapper) {
        this.individuals = new Individual[populationSize];
        if (initialise) {
            int i = 0;
            while (i < this.size()) {
                Individual newIndividual = new Individual(mapper);
                newIndividual.generateIndividual();
                this.saveIndividual(i, newIndividual);
                ++i;
            }
        }
    }

    public Individual getIndividual(int index) {
        return this.individuals[index];
    }

    public Individual getFittest() {
        Individual fittest = this.individuals[0];
        int i = 0;
        while (i < this.size()) {
            if (fittest.getFitness() <= this.getIndividual(i).getFitness()) {
                fittest = this.getIndividual(i);
            }
            ++i;
        }
        return fittest;
    }

    public int size() {
        return this.individuals.length;
    }

    public void saveIndividual(int index, Individual indiv) {
        this.individuals[index] = indiv;
    }
}

