/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.mapper.incremental;

import java.util.List;
import pl.kasprowski.etcal.calibration.CalibratorPolynomial;
import pl.kasprowski.etcal.dataunits.DataUnits;
import pl.kasprowski.etcal.evaluation.Errors;
import pl.kasprowski.etcal.evaluation.Evaluator;
import pl.kasprowski.etcal.mapper.MapTargets;
import pl.kasprowski.etcal.mapper.incremental.AbstractEvaluator;

public class EvaluatorDetermination
extends AbstractEvaluator {
    @Override
    public double calculate(double value, List<Integer> mappings) {
        DataUnits datauX = new DataUnits();
        int i = 0;
        while (i < mappings.size()) {
            datauX.add(this.getDus().getDataUnits().get(i));
            ++i;
        }
        DataUnits datau = MapTargets.mapTargets(datauX, mappings);
        CalibratorPolynomial calp = new CalibratorPolynomial();
        calp.setMask("0000000111");
        Evaluator e = new Evaluator();
        Errors errors = e.calculate(calp, datau, 1, 0);
        if (errors.getrSquareX().isNaN() || errors.getrSquareY().isNaN()) {
            return 0.0;
        }
        return errors.getrSquareX() * errors.getrSquareY();
    }

    public String toString() {
        return "INC-CL";
    }
}

