/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.mapper.incremental;

import java.util.List;
import pl.kasprowski.etcal.dataunits.DataUnit;
import pl.kasprowski.etcal.dataunits.Target;
import pl.kasprowski.etcal.mapper.incremental.AbstractEvaluator;

public class EvaluatorDistance
extends AbstractEvaluator {
    @Override
    public double calculate(double value, List<Integer> mappings) {
        double fitness = 0.0;
        if (mappings.size() < 3) {
            fitness = -Math.random();
        }
        int i = 0;
        while (i < mappings.size() - 2) {
            int j = i + 1;
            while (j < mappings.size()) {
                int k = j + 1;
                while (k < mappings.size()) {
                    DataUnit dui = this.getDus().getDataUnits().get(i);
                    DataUnit duj = this.getDus().getDataUnits().get(j);
                    DataUnit duk = this.getDus().getDataUnits().get(k);
                    Target ti = dui.getTargets().get(mappings.get(i));
                    Target tj = duj.getTargets().get(mappings.get(j));
                    Target tk = duk.getTargets().get(mappings.get(k));
                    Target pi = new Target(dui.getVariables().get(0), dui.getVariables().get(1), 1.0);
                    Target pj = new Target(duj.getVariables().get(0), duj.getVariables().get(1), 1.0);
                    Target pk = new Target(duk.getVariables().get(0), duk.getVariables().get(1), 1.0);
                    double distTij = EvaluatorDistance.dist(ti, tj);
                    double distTik = EvaluatorDistance.dist(ti, tk);
                    double distPij = EvaluatorDistance.dist(pi, pj);
                    double distPik = EvaluatorDistance.dist(pi, pk);
                    double v1 = distTij / distTik;
                    double v2 = distPij / distPik;
                    if (v1 > 1.0 && v2 > 1.0 || v1 < 1.0 && v2 < 1.0) {
                        fitness += 1.0;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return fitness;
    }

    static double dist(Target v0, Target v1) {
        double x = v0.getX() - v1.getX();
        double y = v0.getY() - v1.getY();
        return Math.sqrt(x * x + y * y);
    }

    public String toString() {
        return "INC-DIST-k1";
    }
}

