/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.mapper.incremental;

import java.util.List;
import pl.kasprowski.etcal.dataunits.DataUnit;
import pl.kasprowski.etcal.dataunits.Target;
import pl.kasprowski.etcal.mapper.incremental.AbstractEvaluator;

public class EvaluatorDistanceCorr
extends AbstractEvaluator {
    @Override
    public double calculate(double value, List<Integer> mappings) {
        double fitness = 0.0;
        if (mappings.size() < 3) {
            return -Math.random();
        }
        double[] targets = new double[mappings.size() - 1];
        double[] gazes = new double[mappings.size() - 1];
        int i = 0;
        while (i < mappings.size() - 1) {
            DataUnit dui = this.getDus().getDataUnits().get(i);
            Target ti = dui.getTargets().get(mappings.get(i));
            Target pi = new Target(dui.getVariables().get(0), dui.getVariables().get(1), 1.0);
            DataUnit dui1 = this.getDus().getDataUnits().get(i + 1);
            Target ti1 = dui1.getTargets().get(mappings.get(i + 1));
            Target pi1 = new Target(dui1.getVariables().get(0), dui1.getVariables().get(1), 1.0);
            double distT = EvaluatorDistanceCorr.dist(ti, ti1);
            double distP = EvaluatorDistanceCorr.dist(pi, pi1);
            targets[i] = distT;
            gazes[i] = distP;
            ++i;
        }
        fitness = EvaluatorDistanceCorr.correlation(targets, gazes);
        if (Double.isNaN(fitness) || Double.isInfinite(fitness)) {
            fitness = 0.0;
        }
        return fitness;
    }

    static double dist(Target v0, Target v1) {
        double x = v0.getX() - v1.getX();
        double y = v0.getY() - v1.getY();
        return Math.sqrt(x * x + y * y);
    }

    public static double correlation(double[] xs, double[] ys) {
        double sx = 0.0;
        double sy = 0.0;
        double sxx = 0.0;
        double syy = 0.0;
        double sxy = 0.0;
        int n = xs.length;
        int i = 0;
        while (i < n) {
            double x = xs[i];
            double y = ys[i];
            sx += x;
            sy += y;
            sxx += x * x;
            syy += y * y;
            sxy += x * y;
            ++i;
        }
        double cov = sxy / (double)n - sx * sy / (double)n / (double)n;
        double sigmax = Math.sqrt(sxx / (double)n - sx * sx / (double)n / (double)n);
        double sigmay = Math.sqrt(syy / (double)n - sy * sy / (double)n / (double)n);
        return cov / sigmax / sigmay;
    }

    public String toString() {
        return "INC-DIST-COR";
    }
}

