/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.mapper.incremental;

import java.util.ArrayList;
import java.util.List;
import pl.kasprowski.etcal.mapper.incremental.AbstractEvaluator;

public class EvaluatorFusion
extends AbstractEvaluator {
    List<AbstractEvaluator> evaluators = new ArrayList<AbstractEvaluator>();
    List<Double> weights = new ArrayList<Double>();

    public List<AbstractEvaluator> getFitnessCalcs() {
        return this.evaluators;
    }

    public void addAbstractEvaluator(AbstractEvaluator fc, double weight) {
        this.evaluators.add(fc);
        this.weights.add(weight);
    }

    public void removeAbstractEvaluator(int i) {
        this.evaluators.remove(i);
        this.weights.remove(i);
    }

    @Override
    public double calculate(double value, List<Integer> mappings) {
        double fitness = 0.0;
        int i = 0;
        while (i < this.evaluators.size()) {
            AbstractEvaluator fc = this.evaluators.get(i);
            fc.setDus(this.getDus());
            fitness += fc.calculate(value, mappings) * this.weights.get(i);
            ++i;
        }
        return fitness;
    }

    public String toString() {
        return "INC-FUSION";
    }
}

