/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.mapper.incremental;

import java.util.List;
import pl.kasprowski.etcal.dataunits.DataUnit;
import pl.kasprowski.etcal.dataunits.Target;
import pl.kasprowski.etcal.mapper.incremental.AbstractEvaluator;
import pl.kasprowski.etcal.mapper.incremental.Point;

public class EvaluatorSumCos
extends AbstractEvaluator {
    boolean invertedX = false;

    @Override
    public double calculate(double value, List<Integer> mappings) {
        double fitness = 0.0;
        int i = 0;
        while (i < mappings.size() - 1) {
            int j = i + 1;
            while (j < mappings.size()) {
                int index0 = mappings.get(i);
                DataUnit du0 = this.getDus().getDataUnits().get(i);
                Target t0 = du0.getTargets().get(index0);
                int index1 = mappings.get(j);
                DataUnit du1 = this.getDus().getDataUnits().get(j);
                Target t1 = du1.getTargets().get(index1);
                Point vectTarget = new Point(t1.getX() - t0.getX(), t1.getY() - t0.getY());
                if (new Double(vectTarget.x).isNaN() || new Double(vectTarget.y).isNaN()) {
                    System.out.println(t0 + " " + t1);
                }
                Target p0 = new Target(du0.getVariables().get(0), du0.getVariables().get(1), 1.0);
                Target p1 = new Target(du1.getVariables().get(0), du1.getVariables().get(1), 1.0);
                Point vectVars = null;
                vectVars = this.invertedX ? new Point(p0.getX() - p1.getX(), p1.getY() - p0.getY()) : new Point(p1.getX() - p0.getX(), p1.getY() - p0.getY());
                if (!(vectTarget.x == 0.0 && vectTarget.y == 0.0 || vectVars.x == 0.0 && vectVars.y == 0.0)) {
                    fitness += EvaluatorSumCos.cosVect(vectTarget, vectVars);
                }
                ++j;
            }
            ++i;
        }
        if (new Double(fitness).isNaN()) {
            throw new RuntimeException("Fitness is NAN!");
        }
        return fitness;
    }

    static double cosVect(Point v0, Point v1) {
        double scalar = v0.x * v1.x + v0.y * v1.y;
        double len0 = Math.sqrt(v0.x * v0.x + v0.y * v0.y);
        double len1 = Math.sqrt(v1.x * v1.x + v1.y * v1.y);
        if (len0 == 0.0 || len1 == 0.0) {
            throw new RuntimeException("ZERO!");
        }
        double s = scalar / (len0 * len1);
        if (new Double(s).isNaN()) {
            System.out.println(v0 + " " + v1);
            System.out.println(String.valueOf(len0) + " " + len1 + " " + len0 * len1);
            throw new RuntimeException("S is Nan!");
        }
        return s;
    }

    public String toString() {
        return "ISUMCOSFULL";
    }
}

