/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.mapper.incremental;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import pl.kasprowski.etcal.dataunits.DataUnit;
import pl.kasprowski.etcal.dataunits.DataUnits;
import pl.kasprowski.etcal.mapper.Mapper;
import pl.kasprowski.etcal.mapper.incremental.AbstractEvaluator;
import pl.kasprowski.etcal.mapper.incremental.EvaluatorSumCos;
import pl.kasprowski.etcal.mapper.incremental.Mapping;

public class IncrementalMapper
implements Mapper {
    List<Mapping> mappings = new ArrayList<Mapping>();
    DataUnits testUnits;
    private int poolSize = 100;
    private AbstractEvaluator evaluator = new EvaluatorSumCos();

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public AbstractEvaluator getEvaluator() {
        return this.evaluator;
    }

    public void setEvaluator(AbstractEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    @Override
    public List<Integer> map(DataUnits dus) {
        this.evaluator.setDus(dus);
        DataUnit du = this.evaluator.getDus().getDataUnits().get(0);
        int i = 0;
        while (i < du.getTargets().size()) {
            Mapping newMapping = new Mapping(this.evaluator);
            newMapping = newMapping.addIndex(i);
            this.mappings.add(newMapping);
            ++i;
        }
        i = 1;
        while (i < dus.size()) {
            this.addFixation(i);
            ++i;
        }
        Iterator<Mapping> it = this.mappings.iterator();
        ArrayList<Integer> m = new ArrayList<Integer>();
        Iterator<Integer> it2 = it.next().getMapping().iterator();
        while (it2.hasNext()) {
            m.add(it2.next());
        }
        return m;
    }

    public void addFixation(int no) {
        ArrayList<Mapping> newMappings = new ArrayList<Mapping>();
        DataUnit du = this.evaluator.getDus().getDataUnits().get(no);
        for (Mapping m : this.mappings) {
            int i = 0;
            while (i < du.getTargets().size()) {
                Mapping newMapping = m.addIndex(i);
                newMappings.add(newMapping);
                ++i;
            }
        }
        this.mappings = newMappings;
        this.reduceMappings();
    }

    public void reduceMappings() {
        Collections.sort(this.mappings, Collections.reverseOrder());
        ArrayList<Mapping> newMappings = new ArrayList<Mapping>();
        int i = 0;
        Iterator<Mapping> it = this.mappings.iterator();
        while (it.hasNext() && i++ < this.poolSize) {
            newMappings.add(it.next());
        }
        this.mappings = newMappings;
    }

    public static String format(double v) {
        return new DecimalFormat("#.#").format(v);
    }
}

