/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.mapper.incremental;

import java.util.ArrayList;
import java.util.List;
import pl.kasprowski.etcal.mapper.incremental.AbstractEvaluator;

public class Mapping
implements Comparable<Mapping> {
    private List<Integer> mapping = new ArrayList<Integer>();
    private double value;
    private AbstractEvaluator e;

    public List<Integer> getMapping() {
        return this.mapping;
    }

    public double getValue() {
        return this.value;
    }

    public Mapping(AbstractEvaluator e) {
        this.e = e;
        this.mapping = new ArrayList<Integer>();
    }

    public Mapping(Mapping m) {
        this.e = m.e;
        this.mapping = new ArrayList<Integer>(m.mapping);
    }

    public Mapping addIndex(Integer newTarget) {
        Mapping newMapping = new Mapping(this);
        newMapping.mapping.add(newTarget);
        newMapping.value = this.e.calculate(this.value, newMapping.mapping);
        return newMapping;
    }

    @Override
    public int compareTo(Mapping o) {
        if (new Double(this.value).isNaN() || new Double(o.value).isNaN()) {
            throw new RuntimeException("NANS in mapping!");
        }
        double v = this.value - o.value;
        if (v > 0.0) {
            return 1;
        }
        if (v < 0.0) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return "Mapping:" + this.mapping.size() + " " + this.value + " " + this.mapping;
    }
}

