/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.mapper.jgap;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jgap.Chromosome;
import org.jgap.Configuration;
import org.jgap.FitnessFunction;
import org.jgap.Gene;
import org.jgap.Genotype;
import org.jgap.IChromosome;
import org.jgap.NaturalSelector;
import org.jgap.impl.BestChromosomesSelector;
import org.jgap.impl.DefaultConfiguration;
import org.jgap.impl.IntegerGene;
import pl.kasprowski.etcal.dataunits.DataUnits;
import pl.kasprowski.etcal.mapper.Mapper;
import pl.kasprowski.etcal.mapper.jgap.MappingFittnessFunction;
import pl.kasprowski.etcal.optimizer.GeneticOptimizer;

public class GeneticMapper
implements Mapper,
GeneticOptimizer {
    Logger log = Logger.getLogger(GeneticMapper.class);
    private int genPopulation = 10;
    private int genIterations = 10;
    private int numIterationsWithNoProgress = 4;

    @Override
    public int getGenPopulation() {
        return this.genPopulation;
    }

    @Override
    public void setGenPopulation(Integer popSize) {
        this.genPopulation = popSize;
    }

    @Override
    public int getGenIterations() {
        return this.genIterations;
    }

    @Override
    public void setGenIterations(Integer iterations) {
        this.genIterations = iterations;
    }

    public int getNumIterationsWithNoProgress() {
        return this.numIterationsWithNoProgress;
    }

    public void setNumIterationsWithNoProgress(Integer numIterationsWithNoProgress) {
        this.numIterationsWithNoProgress = numIterationsWithNoProgress;
    }

    @Override
    public List<Integer> map(DataUnits dataUnits) throws Exception {
        int size = dataUnits.getDataUnits().size();
        Configuration.reset();
        DefaultConfiguration conf = new DefaultConfiguration();
        MappingFittnessFunction myFunc = new MappingFittnessFunction(dataUnits);
        conf.setFitnessFunction((FitnessFunction)myFunc);
        conf.getNaturalSelectors(false).clear();
        BestChromosomesSelector bcs = new BestChromosomesSelector((Configuration)conf, 1.0);
        bcs.setDoubletteChromosomesAllowed(false);
        conf.addNaturalSelector((NaturalSelector)bcs, false);
        Gene[] sampleGenes = new Gene[size];
        int i = 0;
        while (i < size) {
            int max = dataUnits.getDataUnits().get(i).getTargets().size() - 1;
            sampleGenes[i] = new IntegerGene((Configuration)conf, 0, max);
            ++i;
        }
        Chromosome sampleChromosome = new Chromosome((Configuration)conf, sampleGenes);
        conf.setSampleChromosome((IChromosome)sampleChromosome);
        conf.setPopulationSize(this.genPopulation);
        this.log.debug((Object)"Starting evolution");
        Genotype population = Genotype.randomInitialGenotype((Configuration)conf);
        IChromosome bestInitialSolution = population.getFittestChromosome();
        IChromosome currentBestSolution = (IChromosome)bestInitialSolution.clone();
        int iterationsWithNoProgress = 0;
        int i2 = 0;
        while (i2 < this.genIterations) {
            this.log.trace((Object)("Iteration " + i2));
            population.evolve();
            IChromosome newBestSolution = population.getFittestChromosome();
            this.log.trace((Object)("New Best solution: " + newBestSolution.getGene(0)));
            if (myFunc.getFitnessValue(newBestSolution) <= myFunc.getFitnessValue(currentBestSolution)) {
                this.log.trace((Object)"Current solution doesn't improve the previous one");
                ++iterationsWithNoProgress;
            } else {
                iterationsWithNoProgress = 0;
                currentBestSolution = (IChromosome)newBestSolution.clone();
            }
            if (iterationsWithNoProgress > this.numIterationsWithNoProgress) {
                this.log.trace((Object)("No progress for " + iterationsWithNoProgress + " iterations - aborting"));
                break;
            }
            this.log.trace((Object)("Iteration " + i2 + " result\t" + 1.0 / myFunc.getFitnessValue(currentBestSolution) + " " + GeneticMapper.chromosomeToMapping(currentBestSolution)));
            ++i2;
        }
        this.log.debug((Object)("Evolution finished, best: " + 1.0 / myFunc.getFitnessValue(currentBestSolution) + " " + GeneticMapper.chromosomeToMapping(currentBestSolution)));
        return GeneticMapper.chromosomeToMapping(currentBestSolution);
    }

    public static List<Integer> chromosomeToMapping(IChromosome chromosome) {
        ArrayList<Integer> mapping = new ArrayList<Integer>();
        int i = 0;
        while (i < chromosome.getGenes().length) {
            Gene gene = chromosome.getGene(i);
            mapping.add((Integer)gene.getAllele());
            ++i;
        }
        return mapping;
    }
}

