/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.mapper.jgap;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.apache.log4j.Logger;
import org.jgap.FitnessFunction;
import org.jgap.IChromosome;
import pl.kasprowski.etcal.calibration.CalibratorPolynomial;
import pl.kasprowski.etcal.calibration.RegressionData;
import pl.kasprowski.etcal.calibration.polynomial.MaskedPolynomialProblem;
import pl.kasprowski.etcal.dataunits.DU2RDConverter;
import pl.kasprowski.etcal.dataunits.DataUnits;
import pl.kasprowski.etcal.evaluation.Evaluator;
import pl.kasprowski.etcal.mapper.MapTargets;
import pl.kasprowski.etcal.mapper.jgap.GeneticMapper;

public class MappingFittnessFunction
extends FitnessFunction {
    static Logger log = Logger.getLogger(MappingFittnessFunction.class);
    private static final long serialVersionUID = 1L;
    Map<List<Integer>, Double> alreadyCalculated = new HashMap<List<Integer>, Double>();
    DataUnits data;

    public MappingFittnessFunction(DataUnits data) {
        this.data = data;
        log.trace((Object)"Fittness function created");
    }

    protected double evaluate(IChromosome chromosome) {
        List<Integer> mapping = GeneticMapper.chromosomeToMapping(chromosome);
        for (List<Integer> ch : this.alreadyCalculated.keySet()) {
            if (!ch.equals(mapping)) continue;
            log.trace((Object)("Chromosome " + mapping + " already calculated with value " + 1.0 / this.alreadyCalculated.get(mapping) + "!"));
            return 1.0 / this.alreadyCalculated.get(mapping);
        }
        try {
            DataUnits datau = MapTargets.mapTargets(this.data, mapping);
            RegressionData rData = DU2RDConverter.dataUnits2RegressionData(datau);
            StringBuffer bmask = new StringBuffer("");
            int i = 0;
            while (i < MaskedPolynomialProblem.termsNum(rData.xNum())) {
                bmask.append("0");
                ++i;
            }
            i = bmask.length() - rData.xNum() - 1;
            while (i < bmask.length()) {
                bmask.replace(i, i + 1, "1");
                ++i;
            }
            String mask = bmask.toString();
            CalibratorPolynomial calp = new CalibratorPolynomial();
            calp.setMask(mask);
            Evaluator e = new Evaluator();
            long ts = System.currentTimeMillis();
            double error = Double.MAX_VALUE;
            error = e.calculate(calp, datau, 1, 0).getAbsError();
            log.trace((Object)("checking: " + mapping + " time = " + (System.currentTimeMillis() - ts) + " result = " + new DecimalFormat("#.###").format(1.0 / error)));
            this.alreadyCalculated.put(mapping, error);
            return 1.0 / error;
        }
        catch (TooManyEvaluationsException ex) {
            log.trace((Object)"Problem too complicated, skipping...");
        }
        catch (Exception ex) {
            log.trace((Object)ex);
        }
        this.alreadyCalculated.put(mapping, 0.0);
        return 0.0;
    }
}

