/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.optimizer.polynomial;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import pl.kasprowski.etcal.calibration.CalibratorPolynomial;
import pl.kasprowski.etcal.calibration.RegressionData;
import pl.kasprowski.etcal.calibration.polynomial.MaskedPolynomialProblem;
import pl.kasprowski.etcal.dataunits.DU2RDConverter;
import pl.kasprowski.etcal.dataunits.DataUnits;
import pl.kasprowski.etcal.evaluation.Evaluator;
import pl.kasprowski.etcal.optimizer.polynomial.PolynomialOptimizer;

public class FullPolynomialOptimizer
extends PolynomialOptimizer {
    Logger log = Logger.getLogger(FullPolynomialOptimizer.class);

    @Override
    public void optimize(DataUnits dataUnits) throws Exception {
        this.setDataUnits(dataUnits);
        RegressionData data = DU2RDConverter.dataUnits2RegressionData(dataUnits);
        Evaluator e = new Evaluator();
        System.out.println("size=" + MaskedPolynomialProblem.termsNum(data.xNum()));
        List<boolean[]> masks = FullPolynomialOptimizer.generateAllMasks(MaskedPolynomialProblem.termsNum(data.xNum()));
        System.out.println(masks.size());
        int i = 0;
        double minError = -1.0;
        boolean[] minMask = new boolean[1];
        for (boolean[] mask : masks) {
            CalibratorPolynomial calp = new CalibratorPolynomial();
            calp.setMask(MaskedPolynomialProblem.maskAsString(mask));
            double error = e.calculate(calp, dataUnits, this.getCvFolds(), this.getCvType()).getAbsError();
            if (minError == -1.0 || minError > error) {
                minError = error;
                minMask = mask;
                this.setBest(minMask);
            }
            this.log.trace((Object)(String.valueOf(i++) + "\t" + MaskedPolynomialProblem.maskAsString(mask) + "\t" + new DecimalFormat("#.####").format(error)));
        }
        this.setBest(minMask);
    }

    static List<boolean[]> generateAllMasks(int bits) {
        int size = 1 << bits;
        ArrayList<boolean[]> masks = new ArrayList<boolean[]>();
        int val = 1;
        while (val < size) {
            boolean[] m = new boolean[bits];
            int i = bits - 1;
            while (i >= 0) {
                m[i] = (val & 1 << i) != 0;
                --i;
            }
            masks.add(m);
            ++val;
        }
        return masks;
    }
}

