/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.optimizer.polynomial;

import org.apache.log4j.Logger;
import org.jgap.Chromosome;
import org.jgap.Configuration;
import org.jgap.FitnessFunction;
import org.jgap.Gene;
import org.jgap.Genotype;
import org.jgap.IChromosome;
import org.jgap.impl.BooleanGene;
import org.jgap.impl.DefaultConfiguration;
import pl.kasprowski.etcal.calibration.polynomial.MaskedPolynomialProblem;
import pl.kasprowski.etcal.dataunits.DataUnits;
import pl.kasprowski.etcal.optimizer.GeneticOptimizer;
import pl.kasprowski.etcal.optimizer.polynomial.PolynomialFittnessFunction;
import pl.kasprowski.etcal.optimizer.polynomial.PolynomialOptimizer;

public class GeneticPolynomialOptimizer
extends PolynomialOptimizer
implements GeneticOptimizer {
    Logger log = Logger.getLogger(GeneticPolynomialOptimizer.class);
    private int genPopulation = 10;
    private int genIterations = 10;
    private int numIterationsWithNoProgress = 4;

    @Override
    public int getGenPopulation() {
        return this.genPopulation;
    }

    @Override
    public void setGenPopulation(Integer popSize) {
        this.genPopulation = popSize;
    }

    @Override
    public int getGenIterations() {
        return this.genIterations;
    }

    @Override
    public void setGenIterations(Integer iterations) {
        this.genIterations = iterations;
    }

    public int getNumIterationsWithNoProgress() {
        return this.numIterationsWithNoProgress;
    }

    public void setNumIterationsWithNoProgress(Integer numIterationsWithNoProgress) {
        this.numIterationsWithNoProgress = numIterationsWithNoProgress;
    }

    @Override
    public void optimize(DataUnits dataUnits) throws Exception {
        this.setDataUnits(dataUnits);
        Configuration.reset();
        DefaultConfiguration conf = new DefaultConfiguration();
        PolynomialFittnessFunction myFunc = new PolynomialFittnessFunction(dataUnits, this.getCvFolds(), this.getCvType());
        conf.setFitnessFunction((FitnessFunction)myFunc);
        int size = MaskedPolynomialProblem.termsNum(dataUnits.xNum());
        Gene[] sampleGenes = new Gene[size];
        int i = 0;
        while (i < size) {
            sampleGenes[i] = new BooleanGene((Configuration)conf);
            ++i;
        }
        Chromosome sampleChromosome = new Chromosome((Configuration)conf, sampleGenes);
        conf.setSampleChromosome((IChromosome)sampleChromosome);
        conf.setPopulationSize(this.genPopulation);
        this.log.debug((Object)"Starting evolution");
        Genotype population = Genotype.randomInitialGenotype((Configuration)conf);
        population.evolve();
        IChromosome bestInitialSolution = population.getFittestChromosome();
        this.log.trace((Object)("BEST: " + MaskedPolynomialProblem.maskAsString(this.chromosomeToMask(bestInitialSolution))));
        this.setBest(this.chromosomeToMask(bestInitialSolution));
        IChromosome currentBestSolution = (IChromosome)bestInitialSolution.clone();
        int iterationsWithNoProgress = 0;
        int i2 = 0;
        while (i2 < this.genIterations) {
            this.log.trace((Object)("Iteration " + i2));
            population.evolve();
            IChromosome newBestSolution = population.getFittestChromosome();
            if (myFunc.getFitnessValue(newBestSolution) <= myFunc.getFitnessValue(currentBestSolution)) {
                this.log.trace((Object)"Current solution doesn't improve the previous one");
                ++iterationsWithNoProgress;
            } else {
                iterationsWithNoProgress = 0;
                currentBestSolution = (IChromosome)newBestSolution.clone();
                this.setBest(this.chromosomeToMask(currentBestSolution));
            }
            if (iterationsWithNoProgress > this.numIterationsWithNoProgress) {
                this.log.trace((Object)("No progress for " + iterationsWithNoProgress + " iterations - aborting"));
                break;
            }
            this.log.trace((Object)("Iteration " + i2 + " result\t" + MaskedPolynomialProblem.maskAsString(this.chromosomeToMask(currentBestSolution)) + "\t" + 1.0 / myFunc.getFitnessValue(currentBestSolution)));
            ++i2;
        }
        this.setBest(this.chromosomeToMask(currentBestSolution));
        this.log.debug((Object)("Evolution finished, best: " + MaskedPolynomialProblem.maskAsString(this.chromosomeToMask(currentBestSolution)) + "\t" + 1.0 / myFunc.getFitnessValue(currentBestSolution)));
    }

    boolean[] chromosomeToMask(IChromosome chromosome) {
        boolean[] mask = new boolean[chromosome.getGenes().length];
        int i = 0;
        while (i < chromosome.getGenes().length) {
            Gene gene = chromosome.getGene(i);
            mask[i] = (Boolean)gene.getAllele();
            ++i;
        }
        return mask;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " genPopulations=" + this.getGenPopulation() + " genIterations=" + this.getGenIterations();
    }
}

