/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.optimizer.polynomial;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.apache.log4j.Logger;
import org.jgap.FitnessFunction;
import org.jgap.Gene;
import org.jgap.IChromosome;
import pl.kasprowski.etcal.calibration.CalibratorPolynomial;
import pl.kasprowski.etcal.calibration.polynomial.MaskedPolynomialProblem;
import pl.kasprowski.etcal.dataunits.DataUnits;
import pl.kasprowski.etcal.evaluation.Evaluator;

public class PolynomialFittnessFunction
extends FitnessFunction {
    static Logger log = Logger.getLogger(PolynomialFittnessFunction.class);
    private static final long serialVersionUID = 1L;
    Map<String, Double> alreadyCalculated = new HashMap<String, Double>();
    DataUnits data;
    int cvSets;
    int cvType;

    public PolynomialFittnessFunction(DataUnits data, int cvSets, int cvType) {
        this.data = data;
        this.cvSets = cvSets;
        this.cvType = cvType;
    }

    protected double evaluate(IChromosome chromosome) {
        for (String map : this.alreadyCalculated.keySet()) {
            if (!map.equals(MaskedPolynomialProblem.maskAsString(this.chromosomeToMask(chromosome)))) continue;
            log.trace((Object)(" >" + map + " already calculated with value " + this.alreadyCalculated.get(map) + "!"));
            return 1.0 / this.alreadyCalculated.get(map);
        }
        if (this.alreadyCalculated.keySet().contains(chromosome)) {
            log.trace((Object)"Chromosome already calculated!");
            return this.alreadyCalculated.get(chromosome);
        }
        boolean[] mask = this.chromosomeToMask(chromosome);
        try {
            CalibratorPolynomial calp = new CalibratorPolynomial();
            calp.setMask(MaskedPolynomialProblem.maskAsString(mask));
            Evaluator e = new Evaluator();
            long ts = System.currentTimeMillis();
            double error = Double.MAX_VALUE;
            error = e.calculate(calp, this.data, this.cvSets, this.cvType).getAbsError();
            log.trace((Object)("checking: " + MaskedPolynomialProblem.maskAsString(mask) + " time = " + (System.currentTimeMillis() - ts) + " result = " + new DecimalFormat("#.###").format(error)));
            this.alreadyCalculated.put(MaskedPolynomialProblem.maskAsString(this.chromosomeToMask(chromosome)), error);
            return 1.0 / error;
        }
        catch (TooManyEvaluationsException ex) {
            log.trace((Object)"Problem too complicated, skipping...");
        }
        catch (Exception ex) {
            log.trace((Object)ex);
        }
        this.alreadyCalculated.put(MaskedPolynomialProblem.maskAsString(this.chromosomeToMask(chromosome)), (Double)Double.MAX_VALUE);
        return 0.0;
    }

    boolean[] chromosomeToMask(IChromosome chromosome) {
        boolean[] mask = new boolean[chromosome.getGenes().length];
        int i = 0;
        while (i < chromosome.getGenes().length) {
            Gene gene = chromosome.getGene(i);
            mask[i] = (Boolean)gene.getAllele();
            ++i;
        }
        return mask;
    }
}

