/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.optimizer.svr;

import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import pl.kasprowski.etcal.calibration.CalibratorLibSVM;
import pl.kasprowski.etcal.dataunits.DataUnits;
import pl.kasprowski.etcal.evaluation.Evaluator;
import pl.kasprowski.etcal.optimizer.svr.SvrOptimizer;

public class FullSvrOptimizer
extends SvrOptimizer {
    @Override
    public void optimize(DataUnits dataUnits) throws Exception {
        this.setDataUnits(dataUnits);
        Evaluator e = new Evaluator();
        double minError = -1.0;
        int minCost = 0;
        int minGamma = 0;
        int cost = this.minExpCost;
        while (cost <= this.maxExpCost) {
            int gamma = this.minExpGamma;
            while (gamma <= this.maxExpGamma) {
                System.setOut(new PrintStream(new OutputStream(){

                    @Override
                    public void write(int b) throws IOException {
                    }
                }));
                CalibratorLibSVM cw = new CalibratorLibSVM();
                cw.setExpCost(cost);
                cw.setExpGamma(gamma);
                double error = e.calculate(cw, dataUnits, this.getCvFolds(), this.getCvType()).getAbsError();
                System.setOut(new PrintStream(new FileOutputStream(FileDescriptor.out)));
                if (minError == -1.0 || minError > error) {
                    minError = error;
                    minGamma = gamma;
                    minCost = cost;
                    this.setBest(new int[]{cost, gamma});
                }
                ++gamma;
            }
            ++cost;
        }
        this.setBest(new int[]{minCost, minGamma});
    }
}

