/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.optimizer.svr;

import org.apache.log4j.Logger;
import org.jgap.Chromosome;
import org.jgap.Configuration;
import org.jgap.FitnessFunction;
import org.jgap.Gene;
import org.jgap.Genotype;
import org.jgap.IChromosome;
import org.jgap.impl.DefaultConfiguration;
import org.jgap.impl.IntegerGene;
import pl.kasprowski.etcal.dataunits.DataUnits;
import pl.kasprowski.etcal.optimizer.GeneticOptimizer;
import pl.kasprowski.etcal.optimizer.svr.SvrFittnessFunction;
import pl.kasprowski.etcal.optimizer.svr.SvrOptimizer;

public class GeneticSvrOptimizer
extends SvrOptimizer
implements GeneticOptimizer {
    Logger log = Logger.getLogger(GeneticSvrOptimizer.class);
    private int genPopulation = 10;
    private int genIterations = 10;

    @Override
    public int getGenPopulation() {
        return this.genPopulation;
    }

    @Override
    public void setGenPopulation(Integer popSize) {
        this.genPopulation = popSize;
    }

    @Override
    public int getGenIterations() {
        return this.genIterations;
    }

    @Override
    public void setGenIterations(Integer iterations) {
        this.genIterations = iterations;
    }

    @Override
    public void optimize(DataUnits dataUnits) throws Exception {
        this.setDataUnits(dataUnits);
        Configuration.reset();
        DefaultConfiguration conf = new DefaultConfiguration();
        SvrFittnessFunction myFunc = new SvrFittnessFunction(dataUnits, this.getCvFolds(), this.getCvType());
        conf.setFitnessFunction((FitnessFunction)myFunc);
        this.log.debug((Object)"Starting SVR optimization");
        Gene[] sampleGenes = new Gene[]{new IntegerGene((Configuration)conf, this.minExpCost, this.maxExpCost), new IntegerGene((Configuration)conf, this.minExpGamma, this.maxExpGamma)};
        Chromosome sampleChromosome = new Chromosome((Configuration)conf, sampleGenes);
        conf.setSampleChromosome((IChromosome)sampleChromosome);
        conf.setPopulationSize(this.getGenPopulation());
        Genotype population = Genotype.randomInitialGenotype((Configuration)conf);
        population.evolve();
        IChromosome bestSolutionSoFar = population.getFittestChromosome();
        System.out.println("BEST: " + this.show(this.chromosomeToParams(bestSolutionSoFar)));
        this.setBest(this.chromosomeToParams(bestSolutionSoFar));
        int iterationsWithNoProgress = 0;
        IChromosome previousBestSolution = bestSolutionSoFar;
        int i = 0;
        while (i < this.getGenIterations()) {
            this.log.trace((Object)("Iteration " + i));
            population.evolve();
            bestSolutionSoFar = population.getFittestChromosome();
            this.setBest(this.chromosomeToParams(bestSolutionSoFar));
            if (myFunc.getFitnessValue(bestSolutionSoFar) <= myFunc.getFitnessValue(previousBestSolution)) {
                this.log.trace((Object)"Current solution doesn't improve the previous one");
                ++iterationsWithNoProgress;
            } else {
                iterationsWithNoProgress = 0;
            }
            if (iterationsWithNoProgress > 30) {
                this.log.trace((Object)("No progress for " + iterationsWithNoProgress + " iterations - aborting"));
                break;
            }
            previousBestSolution = bestSolutionSoFar;
            this.log.trace((Object)(String.valueOf(i) + "\t" + this.show(this.chromosomeToParams(bestSolutionSoFar)) + "\t" + 1.0 / myFunc.getFitnessValue(bestSolutionSoFar)));
            ++i;
        }
        this.setBest(this.chromosomeToParams(population.getFittestChromosome()));
    }

    double[] intToDouble(int[] x) {
        double[] y = new double[x.length];
        int i = 0;
        while (i < x.length) {
            y[i] = x[i];
            ++i;
        }
        return y;
    }

    int[] chromosomeToParams(IChromosome chromosome) {
        int[] res = new int[3];
        int i = 0;
        while (i < chromosome.getGenes().length) {
            Gene gene = chromosome.getGene(i);
            res[i] = (Integer)gene.getAllele();
            ++i;
        }
        return res;
    }

    String show(int[] x) {
        return String.valueOf(x[0]) + " " + x[1] + " " + x[2];
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " genPoluplations=" + this.getGenPopulation() + " genIterations=" + this.getGenIterations();
    }
}

