/*
 * Decompiled with CFR 0.152.
 */
package pl.kasprowski.etcal.plot;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.apache.log4j.Logger;
import pl.kasprowski.etcal.calibration.RegressionData;
import pl.kasprowski.etcal.dataunits.DU2RDConverter;
import pl.kasprowski.etcal.dataunits.DataUnits;

public class Plotter {
    Logger log = Logger.getLogger(Plotter.class);
    private boolean autoClose = false;

    public Plotter() {
    }

    public Plotter(boolean autoClose) {
        this.autoClose = autoClose;
    }

    public void displayPlot(String caption, BufferedImage img) {
        JFrame frame = new JFrame(caption);
        if (this.autoClose) {
            frame.setDefaultCloseOperation(3);
        }
        frame.setSize(img.getWidth(), img.getHeight());
        JLabel label = new JLabel(new ImageIcon(img));
        frame.add(label);
        frame.pack();
        frame.setVisible(true);
    }

    public BufferedImage plot(DataUnits dataUnits1, DataUnits dataUnits2, double sizeX, double sizeY, int crossSize) {
        return this.plot(dataUnits1, dataUnits2, sizeX, sizeY, crossSize, true);
    }

    public BufferedImage plot(DataUnits dataUnits1, DataUnits dataUnits2, double sizeX, double sizeY, int crossSize, boolean showTargets) {
        return this.plot(dataUnits1, dataUnits2, sizeX, sizeY, crossSize, showTargets, showTargets);
    }

    public BufferedImage plot(DataUnits dataUnits1, DataUnits dataUnits2, double sizeX, double sizeY, int crossSize, boolean showTargets1, boolean showTargets2) {
        double y;
        double x;
        int i;
        RegressionData data1 = DU2RDConverter.dataUnits2RegressionData(dataUnits1);
        RegressionData data2 = DU2RDConverter.dataUnits2RegressionData(dataUnits2);
        BufferedImage img = new BufferedImage((int)sizeX, (int)sizeY, 1);
        double maxX = 0.0;
        double maxY = 0.0;
        double minX = 10000.0;
        double minY = 10000.0;
        int i2 = 0;
        while ((double)i2 < sizeX) {
            int j = 0;
            while ((double)j < sizeY) {
                img.setRGB(i2, j, 0xFFFFFF);
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < data1.size()) {
            double x2 = data1.getY1(i2);
            double y2 = data1.getY2(i2);
            if (x2 > maxX) {
                maxX = x2;
            }
            if (y2 > maxY) {
                maxY = y2;
            }
            if (x2 < minX) {
                minX = x2;
            }
            if (y2 < minY) {
                minY = y2;
            }
            double xx = data2.getY1(i2);
            double yy = data2.getY2(i2);
            if (x2 > maxX) {
                maxX = xx;
            }
            if (y2 > maxY) {
                maxY = yy;
            }
            if (x2 < minX) {
                minX = xx;
            }
            if (y2 < minY) {
                minY = yy;
            }
            ++i2;
        }
        System.out.println("minX=" + minX + " maxX=" + maxX + " minY=" + minY + " maxY=" + maxY);
        double brX = (maxX - minX) / 1.0;
        double brY = (maxY - minY) / 1.0;
        this.log.trace((Object)("minX=" + (minX -= brX) + " maxX=" + (maxX += brX) + " minY=" + (minY -= brY) + " maxY=" + (maxY += brY)));
        Graphics2D gr = img.createGraphics();
        int s = crossSize;
        if (data1.size() == data2.size()) {
            i = 0;
            while (i < data2.size()) {
                x = 0.0;
                y = 0.0;
                double xx = 0.0;
                double yy = 0.0;
                if (showTargets1 && showTargets2) {
                    x = (data1.getY1(i) - minX) * sizeX / (maxX - minX);
                    y = (data1.getY2(i) - minY) * sizeY / (maxY - minY);
                    xx = (data2.getY1(i) - minX) * sizeX / (maxX - minX);
                    yy = (data2.getY2(i) - minY) * sizeY / (maxY - minY);
                } else {
                    x = (data1.getX(i)[0] - minX) * sizeX / (maxX - minX);
                    y = (data1.getX(i)[1] - minY) * sizeY / (maxY - minY);
                    xx = (data2.getX(i)[0] - minX) * sizeX / (maxX - minX);
                    yy = (data2.getX(i)[1] - minY) * sizeY / (maxY - minY);
                }
                gr.setColor(Color.GREEN);
                gr.drawLine((int)x, (int)y, (int)xx, (int)yy);
                ++i;
            }
        }
        i = 0;
        while (i < data1.size()) {
            x = 0.0;
            y = 0.0;
            if (showTargets1) {
                x = (data1.getY1().get(i) - minX) * sizeX / (maxX - minX);
                y = (data1.getY2().get(i) - minY) * sizeY / (maxY - minY);
            } else {
                x = (data1.getX(i)[0] - minX) * sizeX / (maxX - minX);
                y = (data1.getX(i)[1] - minY) * sizeY / (maxY - minY);
            }
            gr.setColor(Color.RED);
            gr.drawLine((int)x - s, (int)y - s, (int)x + s, (int)y + s);
            gr.drawLine((int)x - s, (int)y + s, (int)x + s, (int)y - s);
            ++i;
        }
        i = 0;
        while (i < data2.size()) {
            x = 0.0;
            y = 0.0;
            if (showTargets2) {
                x = (data2.getY1().get(i) - minX) * sizeX / (maxX - minX);
                y = (data2.getY2().get(i) - minY) * sizeY / (maxY - minY);
            } else {
                x = (data2.getX(i)[0] - minX) * sizeX / (maxX - minX);
                y = (data2.getX(i)[1] - minY) * sizeY / (maxY - minY);
            }
            gr.setColor(Color.BLUE);
            gr.drawLine((int)x - s, (int)y, (int)x + s, (int)y);
            gr.drawLine((int)x, (int)y + s, (int)x, (int)y - s);
            ++i;
        }
        return img;
    }
}

